/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.solr.client.solrj.cloud.AlreadyExistsException;
import org.apache.solr.client.solrj.cloud.BadVersionException;
import org.apache.solr.client.solrj.cloud.DelegatingCloudManager;
import org.apache.solr.client.solrj.cloud.DelegatingClusterStateProvider;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.NotEmptyException;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.VersionedData;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.cloud.DistributedClusterStateUpdater;
import org.apache.solr.cloud.RefreshCollectionMessage;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.CollectionHandlingUtils;
import org.apache.solr.cloud.api.collections.DeleteCollectionCmd;
import org.apache.solr.cloud.overseer.ClusterStateMutator;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.PerReplicaStatesOps;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.ConfigSetsHandler;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateCollectionCmd
implements CollApiCmds.CollectionApiCommand {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CollectionCommandContext ccc;

    public CreateCollectionCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) throws Exception {
        if (this.ccc.getZkStateReader().aliasesManager != null) {
            this.ccc.getZkStateReader().aliasesManager.update();
        }
        Aliases aliases = this.ccc.getZkStateReader().getAliases();
        String collectionName = message.getStr("name");
        boolean waitForFinalState = message.getBool("waitForFinalState", false);
        String alias = message.getStr("alias", collectionName);
        log.info("Create collection {}", (Object)collectionName);
        boolean isPRS = message.getBool("perReplicaState", false);
        if (clusterState.hasCollection(collectionName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "collection already exists: " + collectionName);
        }
        if (aliases.hasAlias(collectionName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "collection alias already exists: " + collectionName);
        }
        String configName = this.getConfigName(collectionName, message);
        if (configName == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No config set found to associate with the collection.");
        }
        CollectionHandlingUtils.validateConfigOrThrowSolrException(this.ccc.getCoreContainer().getConfigSetService(), configName);
        String router = message.getStr("router.name", "compositeId");
        List<String> shardNames = CreateCollectionCmd.populateShardNames(message, router);
        CreateCollectionCmd.checkReplicaTypes(message);
        DocCollection newColl = null;
        String collectionPath = DocCollection.getCollectionPath((String)collectionName);
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            Map<Object, Object> replicas;
            List<ReplicaPosition> replicaPositions;
            String async = message.getStr("async");
            ZkStateReader zkStateReader = this.ccc.getZkStateReader();
            message.getProperties().put("collection.configName", configName);
            HashMap<String, String> collectionParams = new HashMap<String, String>();
            Map collectionProps = message.getProperties();
            for (Map.Entry entry : collectionProps.entrySet()) {
                String propName = (String)entry.getKey();
                if (!propName.startsWith("collection.")) continue;
                collectionParams.put(propName.substring("collection.".length()), (String)entry.getValue());
            }
            CreateCollectionCmd.createCollectionZkNode(this.ccc.getSolrCloudManager().getDistribStateManager(), collectionName, collectionParams, this.ccc.getCoreContainer().getConfigSetService());
            if (isPRS) {
                ZkWriteCommand command = new ClusterStateMutator(this.ccc.getSolrCloudManager()).createCollection(clusterState, message);
                byte[] data = Utils.toJSON(Collections.singletonMap(collectionName, command.collection));
                this.ccc.getZkStateReader().getZkClient().create(collectionPath, data, CreateMode.PERSISTENT, true);
                clusterState = clusterState.copyWith(collectionName, command.collection);
                newColl = command.collection;
                this.ccc.submitIntraProcessMessage(new RefreshCollectionMessage(collectionName));
            } else {
                if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
                    this.ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.ClusterCreateCollection, message, this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
                } else {
                    this.ccc.offerStateUpdate(Utils.toJSON((Object)message));
                }
                try {
                    newColl = zkStateReader.waitForState(collectionName, 30L, TimeUnit.SECONDS, Objects::nonNull);
                }
                catch (TimeoutException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully create collection: " + collectionName, (Throwable)e);
                }
                clusterState = this.ccc.getSolrCloudManager().getClusterState();
            }
            try {
                replicaPositions = CreateCollectionCmd.buildReplicaPositions(this.ccc.getCoreContainer(), this.ccc.getSolrCloudManager(), clusterState, message, shardNames);
            }
            catch (Assign.AssignmentException e) {
                ZkNodeProps deleteMessage = new ZkNodeProps(new String[]{"name", collectionName});
                new DeleteCollectionCmd(this.ccc).call(clusterState, deleteMessage, results);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e.getMessage(), e.getCause());
            }
            if (replicaPositions.isEmpty()) {
                log.debug("Finished create command for collection: {}", (Object)collectionName);
                return;
            }
            CollectionHandlingUtils.ShardRequestTracker shardRequestTracker = CollectionHandlingUtils.asyncRequestTracker(async, this.ccc);
            if (log.isDebugEnabled()) {
                log.debug(StrUtils.formatString((String)"Creating SolrCores for new collection {0}, shardNames {1} , message : {2}", (Object[])new Object[]{collectionName, shardNames, message}));
            }
            LinkedHashMap<String, ShardRequest> coresToCreate = new LinkedHashMap<String, ShardRequest>();
            ShardHandler shardHandler = this.ccc.newShardHandler();
            DistributedClusterStateUpdater.StateChangeRecorder scr = !isPRS && this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate() ? this.ccc.getDistributedClusterStateUpdater().createStateChangeRecorder(collectionName, false) : null;
            for (ReplicaPosition replicaPosition : replicaPositions) {
                String string = replicaPosition.node;
                String coreName = Assign.buildSolrCoreName(this.ccc.getSolrCloudManager().getDistribStateManager(), collectionName, this.ccc.getSolrCloudManager().getClusterState().getCollectionOrNull(collectionName), replicaPosition.shard, replicaPosition.type, true);
                if (log.isDebugEnabled()) {
                    log.debug(StrUtils.formatString((String)"Creating core {0} as part of shard {1} of collection {2} on {3}", (Object[])new Object[]{coreName, replicaPosition.shard, collectionName, string}));
                }
                String baseUrl = zkStateReader.getBaseUrlForNodeName(string);
                ZkNodeProps props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.ADDREPLICA.toString(), "collection", collectionName, "shard", replicaPosition.shard, "core", coreName, "state", Replica.State.DOWN.toString(), "node_name", string, "base_url", baseUrl, "type", replicaPosition.type.name(), "waitForFinalState", Boolean.toString(waitForFinalState)});
                if (isPRS) {
                    ZkWriteCommand command = new SliceMutator(this.ccc.getSolrCloudManager()).addReplica(clusterState, props);
                    clusterState = clusterState.copyWith(collectionName, command.collection);
                    newColl = command.collection;
                } else if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
                    scr.record(DistributedClusterStateUpdater.MutatingCommand.SliceAddReplica, props);
                } else {
                    this.ccc.offerStateUpdate(Utils.toJSON((Object)props));
                }
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
                params.set("name", new String[]{coreName});
                params.set("collection.configName", new String[]{configName});
                params.set("collection", new String[]{collectionName});
                params.set("shard", new String[]{replicaPosition.shard});
                params.set("numShards", shardNames.size());
                params.set("newCollection", new String[]{"true"});
                params.set("replicaType", new String[]{replicaPosition.type.name()});
                if (async != null) {
                    String coreAdminAsyncId = async + Math.abs(System.nanoTime());
                    params.add("async", new String[]{coreAdminAsyncId});
                    shardRequestTracker.track(string, coreAdminAsyncId);
                }
                CollectionHandlingUtils.addPropertyParams(message, params);
                ShardRequest sreq = new ShardRequest();
                sreq.nodeName = string;
                params.set("qt", new String[]{this.ccc.getAdminPath()});
                sreq.purpose = 1;
                sreq.shards = new String[]{baseUrl};
                sreq.actualShards = sreq.shards;
                sreq.params = params;
                coresToCreate.put(coreName, sreq);
            }
            if (isPRS) {
                byte[] data = Utils.toJSON(Collections.singletonMap(collectionName, clusterState.getCollection(collectionName)));
                zkStateReader.getZkClient().setData(collectionPath, data, true);
            }
            if (!isPRS && this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
                scr.executeStateUpdates(this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
            }
            if (isPRS) {
                replicas = new ConcurrentHashMap();
                newColl.getSlices().stream().flatMap(slice -> slice.getReplicas().stream()).filter(r -> coresToCreate.containsKey(r.getCoreName())).forEach(r -> replicas.putIfAbsent(r.getCoreName(), r));
                this.ccc.submitIntraProcessMessage(new RefreshCollectionMessage(collectionName));
            } else {
                replicas = CollectionHandlingUtils.waitToSeeReplicasInState(this.ccc.getZkStateReader(), this.ccc.getSolrCloudManager().getTimeSource(), collectionName, coresToCreate.keySet());
            }
            for (Map.Entry entry : coresToCreate.entrySet()) {
                ShardRequest sreq = (ShardRequest)entry.getValue();
                sreq.params.set("coreNodeName", new String[]{((Replica)replicas.get(entry.getKey())).getName()});
                shardHandler.submit(sreq, sreq.shards[0], sreq.params);
            }
            shardRequestTracker.processResponses(results, shardHandler, false, null, Collections.emptySet());
            boolean bl4 = bl3 = results.get("failure") != null && ((SimpleOrderedMap)results.get("failure")).size() > 0;
            if (isPRS) {
                TimeOut timeOut = new TimeOut(Integer.getInteger("solr.waitToSeeReplicasInStateTimeoutSeconds", 120).intValue(), TimeUnit.SECONDS, this.ccc.getSolrCloudManager().getTimeSource());
                PerReplicaStates prs = PerReplicaStatesOps.fetch((String)collectionPath, (SolrZkClient)this.ccc.getZkStateReader().getZkClient(), null);
                while (!timeOut.hasTimedOut() && !prs.allActive()) {
                    Thread.sleep(100L);
                    prs = PerReplicaStatesOps.fetch((String)collectionPath, (SolrZkClient)this.ccc.getZkStateReader().getZkClient(), null);
                }
                if (!prs.allActive()) {
                    bl2 = true;
                }
            }
            if (bl2) {
                CollectionHandlingUtils.cleanupCollection(collectionName, (NamedList<Object>)new NamedList(), this.ccc);
                log.info("Cleaned up artifacts for failed create collection for [{}]", (Object)collectionName);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Underlying core creation failed while creating collection: " + collectionName);
            }
            this.ccc.submitIntraProcessMessage(new RefreshCollectionMessage(collectionName));
            log.debug("Finished create command on all shards for collection: {}", (Object)collectionName);
            boolean bl5 = bl = message.getStr("collection.configName") == null || message.getStr("collection.configName").equals("_default") || ConfigSetsHandler.isAutoGeneratedConfigSet(message.getStr("collection.configName"));
            if (bl) {
                results.add("warning", (Object)("Using _default configset. Data driven schema functionality is enabled by default, which is NOT RECOMMENDED for production use. To turn it off: curl http://{host:port}/solr/" + collectionName + "/config -d '{\"set-user-property\": {\"update.autoCreateFields\":\"false\"}}'"));
            }
            if (!alias.equals(collectionName)) {
                this.ccc.getZkStateReader().aliasesManager.applyModificationAndExportToZk(a -> a.cloneWithCollectionAlias(alias, collectionName));
            }
        }
        catch (SolrException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)ex);
        }
    }

    private static List<ReplicaPosition> buildReplicaPositions(CoreContainer coreContainer, SolrCloudManager cloudManager, ClusterState clusterState, ZkNodeProps message, List<String> shardNames) throws IOException, InterruptedException, Assign.AssignmentException {
        List<ReplicaPosition> replicaPositions;
        String collectionName = message.getStr("name");
        int numTlogReplicas = message.getInt("tlogReplicas", Integer.valueOf(0));
        int numNrtReplicas = message.getInt("nrtReplicas", message.getInt("replicationFactor", Integer.valueOf(numTlogReplicas > 0 ? 0 : 1)));
        int numPullReplicas = message.getInt("pullReplicas", Integer.valueOf(0));
        int numSlices = shardNames.size();
        cloudManager = CreateCollectionCmd.wrapCloudManager(clusterState, cloudManager);
        List<String> nodeList = Assign.getLiveOrLiveAndCreateNodeSetList(clusterState.getLiveNodes(), message, Utils.RANDOM, cloudManager.getDistribStateManager());
        if (nodeList.isEmpty()) {
            log.warn("It is unusual to create a collection ({}) without cores.", (Object)collectionName);
            replicaPositions = new ArrayList<ReplicaPosition>();
        } else {
            int totalNumReplicas = numNrtReplicas + numTlogReplicas + numPullReplicas;
            if (totalNumReplicas > nodeList.size()) {
                log.warn("Specified number of replicas of {} on collection {} is higher than the number of Solr instances currently live or live and part of your {}({}). {}", new Object[]{totalNumReplicas, collectionName, "createNodeSet", nodeList.size(), "It's unusual to run two replica of the same slice on the same Solr-instance."});
            }
            Assign.AssignRequest assignRequest = new Assign.AssignRequestBuilder().forCollection(collectionName).forShard(shardNames).assignNrtReplicas(numNrtReplicas).assignTlogReplicas(numTlogReplicas).assignPullReplicas(numPullReplicas).onNodes(nodeList).build();
            Assign.AssignStrategy assignStrategy = Assign.createAssignStrategy(coreContainer);
            replicaPositions = assignStrategy.assign(cloudManager, assignRequest);
        }
        return replicaPositions;
    }

    private static SolrCloudManager wrapCloudManager(final ClusterState clusterState, SolrCloudManager solrCloudManager) {
        DelegatingClusterStateProvider csp = new DelegatingClusterStateProvider(solrCloudManager.getClusterStateProvider()){

            public ClusterState.CollectionRef getState(String collection) {
                return clusterState.getCollectionRef(collection);
            }

            public ClusterState getClusterState() {
                return clusterState;
            }

            public DocCollection getCollection(String name) throws IOException {
                return clusterState.getCollection(name);
            }
        };
        return new DelegatingCloudManager(solrCloudManager, (ClusterStateProvider)csp){
            final /* synthetic */ ClusterStateProvider val$csp;
            {
                this.val$csp = clusterStateProvider;
                super(arg0);
            }

            public ClusterStateProvider getClusterStateProvider() {
                return this.val$csp;
            }
        };
    }

    public static void checkReplicaTypes(ZkNodeProps message) {
        int numTlogReplicas = message.getInt("tlogReplicas", Integer.valueOf(0));
        int numNrtReplicas = message.getInt("nrtReplicas", message.getInt("replicationFactor", Integer.valueOf(numTlogReplicas > 0 ? 0 : 1)));
        if (numNrtReplicas + numTlogReplicas <= 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "nrtReplicas + tlogReplicas must be greater than 0");
        }
    }

    public static List<String> populateShardNames(ZkNodeProps message, String router) {
        ArrayList<String> shardNames = new ArrayList<String>();
        Integer numSlices = message.getInt("numShards", null);
        if ("implicit".equals(router)) {
            ClusterStateMutator.getShardNames(shardNames, message.getStr("shards", null));
            numSlices = shardNames.size();
        } else {
            if (numSlices == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards is a required param (when using CompositeId router).");
            }
            if (numSlices <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards must be > 0");
            }
            ClusterStateMutator.getShardNames(numSlices, shardNames);
        }
        return shardNames;
    }

    String getConfigName(String coll, ZkNodeProps message) throws IOException {
        String configName = message.getStr("collection.configName");
        if (configName == null) {
            List<String> configNames = null;
            configNames = this.ccc.getCoreContainer().getConfigSetService().listConfigs();
            if (configNames.contains("_default")) {
                if (".system".equals(coll)) {
                    return coll;
                }
                String intendedConfigSetName = ConfigSetsHandler.getSuffixedNameForAutoGeneratedConfigSet(coll);
                this.copyDefaultConfigSetTo(configNames, intendedConfigSetName);
                return intendedConfigSetName;
            }
            if (configNames != null && configNames.size() == 1) {
                configName = configNames.get(0);
                log.info("Only one config set found in zk - using it: {}", (Object)configName);
            }
        }
        return configName != null && configName.isEmpty() ? null : configName;
    }

    private void copyDefaultConfigSetTo(List<String> configNames, String targetConfig) {
        if (configNames.contains(targetConfig)) {
            log.info("There exists a configset by the same name as the collection we're trying to create: {}, re-using it.", (Object)targetConfig);
            return;
        }
        try {
            this.ccc.getCoreContainer().getConfigSetService().copyConfig("_default", targetConfig);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Error while copying _default to " + targetConfig, (Throwable)e);
        }
    }

    public static void createCollectionZkNode(DistribStateManager stateManager, String collection, Map<String, String> params, ConfigSetService configSetService) {
        block22: {
            log.debug("Check for collection zkNode: {}", (Object)collection);
            String collectionPath = "/collections/" + collection;
            String termsPath = "/collections/" + collection + "/terms";
            try {
                stateManager.removeRecursively(termsPath, true, true);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error deleting old term nodes for collection from Zookeeper", (Throwable)e);
            }
            catch (IOException | BadVersionException | NotEmptyException | KeeperException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error deleting old term nodes for collection from Zookeeper", e);
            }
            try {
                if (!stateManager.hasData(collectionPath)) {
                    log.debug("Creating collection in ZooKeeper: {}", (Object)collection);
                    try {
                        HashMap<String, Object> collectionProps = new HashMap<String, Object>();
                        if (params.size() > 0) {
                            collectionProps.putAll(params);
                            if (!collectionProps.containsKey("configName")) {
                                CreateCollectionCmd.getConfName(stateManager, collection, collectionPath, collectionProps, configSetService);
                            }
                        } else if (System.getProperty("bootstrap_confdir") != null) {
                            String defaultConfigName = System.getProperty("collection.configName", collection);
                            log.info("Setting config for collection: {} to {}", (Object)collection, (Object)defaultConfigName);
                            Properties sysProps = System.getProperties();
                            for (String sprop : System.getProperties().stringPropertyNames()) {
                                if (!sprop.startsWith("collection.")) continue;
                                collectionProps.put(sprop.substring("collection.".length()), sysProps.getProperty(sprop));
                            }
                            if (!collectionProps.containsKey("configName")) {
                                collectionProps.put("configName", defaultConfigName);
                            }
                        } else if (Boolean.getBoolean("bootstrap_conf")) {
                            collectionProps.put("configName", collection);
                        } else {
                            CreateCollectionCmd.getConfName(stateManager, collection, collectionPath, collectionProps, configSetService);
                        }
                        collectionProps.remove("numShards");
                        collectionProps.remove("configName");
                        stateManager.makePath(collectionPath);
                        break block22;
                    }
                    catch (KeeperException e) {
                        if (e.code() != KeeperException.Code.NODEEXISTS) {
                            throw e;
                        }
                        break block22;
                    }
                    catch (AlreadyExistsException e) {
                        break block22;
                    }
                }
                log.debug("Collection zkNode exists");
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) {
                    return;
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating collection node in Zookeeper", (Throwable)e);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating collection node in Zookeeper", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating collection node in Zookeeper", (Throwable)e);
            }
        }
    }

    private static void getConfName(DistribStateManager stateManager, String collection, String collectionPath, Map<String, Object> collectionProps, ConfigSetService configSetService) throws IOException, KeeperException, InterruptedException {
        VersionedData data;
        ZkNodeProps cProps;
        int retry;
        log.debug("Looking for collection configName");
        if (collectionProps.containsKey("configName")) {
            if (log.isInfoEnabled()) {
                log.info("configName was passed as a param {}", collectionProps.get("configName"));
            }
            return;
        }
        List<String> configNames = null;
        int retryLimt = 6;
        for (retry = 1; !(retry >= retryLimt || stateManager.hasData(collectionPath) && (cProps = ZkNodeProps.load((byte[])(data = stateManager.getData(collectionPath)).getData())).containsKey("configName")); ++retry) {
            try {
                configNames = configSetService.listConfigs();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (configNames != null && configNames.contains(collection)) {
                log.info("Could not find explicit collection configName, but found config name matching collection name - using that set.");
                collectionProps.put("configName", collection);
                break;
            }
            if (configNames != null && configNames.contains("_default")) {
                log.info("Could not find explicit collection configName, but found _default config set - using that set.");
                collectionProps.put("configName", "_default");
                break;
            }
            if (configNames != null && configNames.size() == 1) {
                if (log.isInfoEnabled()) {
                    log.info("Only one config set found in zk - using it: {}", (Object)configNames.get(0));
                }
                collectionProps.put("configName", configNames.get(0));
                break;
            }
            log.info("Could not find collection configName - pausing for 3 seconds and trying again - try: {}", (Object)retry);
            Thread.sleep(3000L);
        }
        if (retry == retryLimt) {
            log.error("Could not find configName for collection {}", (Object)collection);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Could not find configName for collection " + collection + " found:" + String.valueOf(configNames));
        }
    }
}

