# frozen_string_literal: true

require 'bundler/setup'
require 'rspec/its'


class TestHelper
  def self.is_jruby?
    Object.const_defined? :JRUBY_VERSION
  end

  def self.is_mri?
    RUBY_ENGINE == "ruby"
  end

  def self.is_windows?
    RUBY_DESCRIPTION =~ /mswin|ming|cygwin/
  end

  def self.native_supported?
    is_mri? && !is_windows?
  end
end

RSpec.configure do |config|
  config.warnings = true
  config.filter_run_when_matching :focus
end
