/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.memorycontainer;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.memorycontainer.PayloadType;
import org.opensearch.ml.common.transport.memorycontainer.memory.MessageInput;
import org.opensearch.ml.common.utils.StringUtils;

public class MLWorkingMemory
implements ToXContentObject,
Writeable {
    private String memoryContainerId;
    private PayloadType payloadType;
    private List<MessageInput> messages;
    private Integer messageId;
    private String binaryData;
    private Map<String, Object> structuredData;
    private Map<String, Object> structuredDataBlob;
    private Map<String, String> namespace;
    private Integer namespaceSize;
    private boolean infer;
    private Map<String, String> metadata;
    private Map<String, String> tags;
    private Instant createdTime;
    private Instant lastUpdateTime;
    private String ownerId;
    private String checkpointId;

    public MLWorkingMemory(String memoryContainerId, PayloadType payloadType, List<MessageInput> messages, Integer messageId, String binaryData, Map<String, Object> structuredData, Map<String, Object> structuredDataBlob, Map<String, String> namespace, boolean infer, Map<String, String> metadata, Map<String, String> tags, Instant createdTime, Instant lastUpdateTime, String ownerId, String checkpointId) {
        this.memoryContainerId = memoryContainerId;
        this.payloadType = payloadType == null ? PayloadType.CONVERSATIONAL : payloadType;
        this.messages = messages;
        this.messageId = messageId;
        this.binaryData = binaryData;
        this.structuredData = structuredData;
        this.structuredDataBlob = structuredDataBlob;
        this.namespace = namespace;
        this.namespaceSize = namespace == null ? null : Integer.valueOf(namespace.size());
        this.infer = infer;
        this.metadata = metadata;
        this.tags = tags;
        this.createdTime = createdTime;
        this.lastUpdateTime = lastUpdateTime;
        this.ownerId = ownerId;
        this.checkpointId = checkpointId;
    }

    public MLWorkingMemory(StreamInput in) throws IOException {
        this.memoryContainerId = in.readOptionalString();
        this.payloadType = (PayloadType)in.readEnum(PayloadType.class);
        if (in.readBoolean()) {
            int messagesSize = in.readVInt();
            this.messages = new ArrayList<MessageInput>(messagesSize);
            for (int i = 0; i < messagesSize; ++i) {
                this.messages.add(new MessageInput(in));
            }
        }
        this.messageId = in.readOptionalInt();
        this.binaryData = in.readOptionalString();
        if (in.readBoolean()) {
            this.structuredData = in.readMap();
        }
        if (in.readBoolean()) {
            this.structuredDataBlob = in.readMap();
        }
        if (in.readBoolean()) {
            this.namespace = in.readMap(StreamInput::readString, StreamInput::readString);
        }
        this.namespaceSize = in.readOptionalInt();
        this.infer = in.readBoolean();
        if (in.readBoolean()) {
            this.metadata = in.readMap(StreamInput::readString, StreamInput::readString);
        }
        if (in.readBoolean()) {
            this.tags = in.readMap(StreamInput::readString, StreamInput::readString);
        }
        this.createdTime = in.readOptionalInstant();
        this.lastUpdateTime = in.readOptionalInstant();
        this.ownerId = in.readOptionalString();
        this.checkpointId = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.memoryContainerId);
        out.writeEnum((Enum)this.payloadType);
        if (this.messages != null) {
            out.writeBoolean(true);
            out.writeVInt(this.messages.size());
            for (MessageInput message : this.messages) {
                message.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInt(this.messageId);
        out.writeOptionalString(this.binaryData);
        if (this.structuredData != null) {
            out.writeBoolean(true);
            out.writeMap(this.structuredData);
        } else {
            out.writeBoolean(false);
        }
        if (this.structuredDataBlob != null) {
            out.writeBoolean(true);
            out.writeMap(this.structuredDataBlob);
        } else {
            out.writeBoolean(false);
        }
        if (this.namespace != null && !this.namespace.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.namespace, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInt(this.namespaceSize);
        out.writeBoolean(this.infer);
        if (this.metadata != null && !this.metadata.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.metadata, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.tags, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInstant(this.createdTime);
        out.writeOptionalInstant(this.lastUpdateTime);
        out.writeOptionalString(this.ownerId);
        out.writeOptionalString(this.checkpointId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.memoryContainerId != null) {
            builder.field("memory_container_id", this.memoryContainerId);
        }
        builder.field("payload_type", (Object)this.payloadType);
        if (this.messages != null && !this.messages.isEmpty()) {
            builder.startArray("messages");
            for (MessageInput message : this.messages) {
                message.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.messageId != null) {
            builder.field("message_id", this.messageId);
        }
        if (this.binaryData != null) {
            builder.field("binary_data", this.binaryData);
        }
        if (this.structuredData != null) {
            builder.field("structured_data", this.structuredData);
        }
        if (this.structuredDataBlob != null) {
            builder.field("structured_data_blob", this.structuredDataBlob);
        }
        if (this.namespace != null && !this.namespace.isEmpty()) {
            builder.field("namespace", this.namespace);
        }
        if (this.namespaceSize != null) {
            builder.field("namespace_size", this.namespaceSize);
        }
        builder.field("infer", this.infer);
        if (this.metadata != null && !this.metadata.isEmpty()) {
            builder.field("metadata", this.metadata);
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            builder.field("tags", this.tags);
        }
        if (this.createdTime != null) {
            builder.field("created_time", this.createdTime.toEpochMilli());
        }
        if (this.lastUpdateTime != null) {
            builder.field("last_updated_time", this.lastUpdateTime.toEpochMilli());
        }
        if (this.ownerId != null) {
            builder.field("owner_id", this.ownerId);
        }
        if (this.checkpointId != null) {
            builder.field("checkpoint_id", this.checkpointId);
        }
        builder.endObject();
        return builder;
    }

    public static MLWorkingMemory parse(XContentParser parser) throws IOException {
        String memoryContainerId = null;
        String payloadType = null;
        ArrayList<MessageInput> messages = null;
        Integer messageId = null;
        String binaryData = null;
        Map structuredData = null;
        Map structuredDataBlob = null;
        Map<String, String> namespace = null;
        boolean infer = false;
        Map<String, String> metadata = null;
        Map<String, String> tags = null;
        Instant createdTime = null;
        Instant lastUpdateTime = null;
        String ownerId = null;
        String checkpointId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block34: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "memory_container_id": {
                    memoryContainerId = parser.text();
                    continue block34;
                }
                case "payload_type": {
                    payloadType = parser.text();
                    continue block34;
                }
                case "messages": {
                    messages = new ArrayList<MessageInput>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        messages.add(MessageInput.parse(parser));
                    }
                    continue block34;
                }
                case "message_id": {
                    messageId = parser.intValue();
                    continue block34;
                }
                case "binary_data": {
                    binaryData = parser.text();
                    continue block34;
                }
                case "structured_data": {
                    structuredData = parser.map();
                    continue block34;
                }
                case "structured_data_blob": {
                    structuredDataBlob = parser.map();
                    continue block34;
                }
                case "namespace": {
                    namespace = StringUtils.getParameterMap(parser.map());
                    continue block34;
                }
                case "infer": {
                    infer = parser.booleanValue();
                    continue block34;
                }
                case "metadata": {
                    metadata = StringUtils.getParameterMap(parser.map());
                    continue block34;
                }
                case "tags": {
                    tags = StringUtils.getParameterMap(parser.map());
                    continue block34;
                }
                case "created_time": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block34;
                }
                case "last_updated_time": {
                    lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block34;
                }
                case "owner_id": {
                    ownerId = parser.text();
                    continue block34;
                }
                case "checkpoint_id": {
                    checkpointId = parser.text();
                    continue block34;
                }
            }
            parser.skipChildren();
        }
        return MLWorkingMemory.builder().memoryContainerId(memoryContainerId).payloadType(payloadType == null ? PayloadType.CONVERSATIONAL : PayloadType.fromString(payloadType)).messages(messages).messageId(messageId).binaryData(binaryData).structuredData(structuredData).structuredDataBlob(structuredDataBlob).namespace(namespace).infer(infer).metadata(metadata).tags(tags).createdTime(createdTime).lastUpdateTime(lastUpdateTime).ownerId(ownerId).checkpointId(checkpointId).build();
    }

    public String getSessionId() {
        return this.namespace == null ? null : this.namespace.get("session_id");
    }

    public String getAgentId() {
        return this.namespace == null ? null : this.namespace.get("agent_id");
    }

    @Generated
    public static MLWorkingMemoryBuilder builder() {
        return new MLWorkingMemoryBuilder();
    }

    @Generated
    public String getMemoryContainerId() {
        return this.memoryContainerId;
    }

    @Generated
    public PayloadType getPayloadType() {
        return this.payloadType;
    }

    @Generated
    public List<MessageInput> getMessages() {
        return this.messages;
    }

    @Generated
    public Integer getMessageId() {
        return this.messageId;
    }

    @Generated
    public String getBinaryData() {
        return this.binaryData;
    }

    @Generated
    public Map<String, Object> getStructuredData() {
        return this.structuredData;
    }

    @Generated
    public Map<String, Object> getStructuredDataBlob() {
        return this.structuredDataBlob;
    }

    @Generated
    public Map<String, String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public Integer getNamespaceSize() {
        return this.namespaceSize;
    }

    @Generated
    public boolean isInfer() {
        return this.infer;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Generated
    public String getOwnerId() {
        return this.ownerId;
    }

    @Generated
    public String getCheckpointId() {
        return this.checkpointId;
    }

    @Generated
    public void setMemoryContainerId(String memoryContainerId) {
        this.memoryContainerId = memoryContainerId;
    }

    @Generated
    public void setPayloadType(PayloadType payloadType) {
        this.payloadType = payloadType;
    }

    @Generated
    public void setMessages(List<MessageInput> messages) {
        this.messages = messages;
    }

    @Generated
    public void setMessageId(Integer messageId) {
        this.messageId = messageId;
    }

    @Generated
    public void setBinaryData(String binaryData) {
        this.binaryData = binaryData;
    }

    @Generated
    public void setStructuredData(Map<String, Object> structuredData) {
        this.structuredData = structuredData;
    }

    @Generated
    public void setStructuredDataBlob(Map<String, Object> structuredDataBlob) {
        this.structuredDataBlob = structuredDataBlob;
    }

    @Generated
    public void setNamespace(Map<String, String> namespace) {
        this.namespace = namespace;
    }

    @Generated
    public void setNamespaceSize(Integer namespaceSize) {
        this.namespaceSize = namespaceSize;
    }

    @Generated
    public void setInfer(boolean infer) {
        this.infer = infer;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setCreatedTime(Instant createdTime) {
        this.createdTime = createdTime;
    }

    @Generated
    public void setLastUpdateTime(Instant lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Generated
    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    @Generated
    public void setCheckpointId(String checkpointId) {
        this.checkpointId = checkpointId;
    }

    @Generated
    public static class MLWorkingMemoryBuilder {
        @Generated
        private String memoryContainerId;
        @Generated
        private PayloadType payloadType;
        @Generated
        private List<MessageInput> messages;
        @Generated
        private Integer messageId;
        @Generated
        private String binaryData;
        @Generated
        private Map<String, Object> structuredData;
        @Generated
        private Map<String, Object> structuredDataBlob;
        @Generated
        private Map<String, String> namespace;
        @Generated
        private boolean infer;
        @Generated
        private Map<String, String> metadata;
        @Generated
        private Map<String, String> tags;
        @Generated
        private Instant createdTime;
        @Generated
        private Instant lastUpdateTime;
        @Generated
        private String ownerId;
        @Generated
        private String checkpointId;

        @Generated
        MLWorkingMemoryBuilder() {
        }

        @Generated
        public MLWorkingMemoryBuilder memoryContainerId(String memoryContainerId) {
            this.memoryContainerId = memoryContainerId;
            return this;
        }

        @Generated
        public MLWorkingMemoryBuilder payloadType(PayloadType payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        @Generated
        public MLWorkingMemoryBuilder messages(List<MessageInput> messages) {
            this.messages = messages;
            return this;
        }

        @Generated
        public MLWorkingMemoryBuilder messageId(Integer messageId) {
            this.messageId = messageId;
            return this;
        }

        @Generated
        public MLWorkingMemoryBuilder binaryData(String binaryData) {
            this.binaryData = binaryData;
            return this;
        }

        @Generated
        public MLWorkingMemoryBuilder structuredData(Map<String, Object> structuredData) {
            this.structuredData = structuredData;
            return this;
        }

        @Generated
        public MLWorkingMemoryBuilder structuredDataBlob(Map<String, Object> structuredDataBlob) {
            this.structuredDataBlob = structuredDataBlob;
            return this;
        }

        @Generated
        public MLWorkingMemoryBuilder namespace(Map<String, String> namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public MLWorkingMemoryBuilder infer(boolean infer) {
            this.infer = infer;
            return this;
        }

        @Generated
        public MLWorkingMemoryBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public MLWorkingMemoryBuilder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        @Generated
        public MLWorkingMemoryBuilder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Generated
        public MLWorkingMemoryBuilder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Generated
        public MLWorkingMemoryBuilder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        @Generated
        public MLWorkingMemoryBuilder checkpointId(String checkpointId) {
            this.checkpointId = checkpointId;
            return this;
        }

        @Generated
        public MLWorkingMemory build() {
            return new MLWorkingMemory(this.memoryContainerId, this.payloadType, this.messages, this.messageId, this.binaryData, this.structuredData, this.structuredDataBlob, this.namespace, this.infer, this.metadata, this.tags, this.createdTime, this.lastUpdateTime, this.ownerId, this.checkpointId);
        }

        @Generated
        public String toString() {
            return "MLWorkingMemory.MLWorkingMemoryBuilder(memoryContainerId=" + this.memoryContainerId + ", payloadType=" + String.valueOf((Object)this.payloadType) + ", messages=" + String.valueOf(this.messages) + ", messageId=" + this.messageId + ", binaryData=" + this.binaryData + ", structuredData=" + String.valueOf(this.structuredData) + ", structuredDataBlob=" + String.valueOf(this.structuredDataBlob) + ", namespace=" + String.valueOf(this.namespace) + ", infer=" + this.infer + ", metadata=" + String.valueOf(this.metadata) + ", tags=" + String.valueOf(this.tags) + ", createdTime=" + String.valueOf(this.createdTime) + ", lastUpdateTime=" + String.valueOf(this.lastUpdateTime) + ", ownerId=" + this.ownerId + ", checkpointId=" + this.checkpointId + ")";
        }
    }
}

