/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.bootstrap;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.ExceptionListener;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.HttpResponseFactory;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.config.NamedElementChain;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.bootstrap.FilterEntry;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer;
import org.apache.hc.core5.http.impl.bootstrap.StandardFilter;
import org.apache.hc.core5.http.impl.io.DefaultBHttpServerConnection;
import org.apache.hc.core5.http.impl.io.DefaultBHttpServerConnectionFactory;
import org.apache.hc.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import org.apache.hc.core5.http.impl.io.HttpService;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.HttpFilterHandler;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.HttpServerRequestHandler;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.ssl.DefaultTlsSetupHandler;
import org.apache.hc.core5.http.io.support.BasicHttpServerExpectationDecorator;
import org.apache.hc.core5.http.io.support.BasicHttpServerRequestHandler;
import org.apache.hc.core5.http.io.support.HttpServerExpectationFilter;
import org.apache.hc.core5.http.io.support.HttpServerFilterChainElement;
import org.apache.hc.core5.http.io.support.HttpServerFilterChainRequestHandler;
import org.apache.hc.core5.http.io.support.TerminalServerFilter;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.LookupRegistry;
import org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import org.apache.hc.core5.http.protocol.UriPatternMatcher;
import org.apache.hc.core5.http.protocol.UriPatternType;
import org.apache.hc.core5.net.InetAddressUtils;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;

public class ServerBootstrap {
    private final List<RequestRouter.Entry<HttpRequestHandler>> routeEntries = new ArrayList<RequestRouter.Entry<HttpRequestHandler>>();
    private final List<FilterEntry<HttpFilterHandler>> filters = new ArrayList<FilterEntry<HttpFilterHandler>>();
    private String canonicalHostName;
    private HttpRequestMapper<HttpRequestHandler> requestRouter;
    private LookupRegistry<HttpRequestHandler> lookupRegistry;
    private int listenerPort;
    private InetAddress localAddress;
    private SocketConfig socketConfig;
    private Http1Config http1Config;
    private CharCodingConfig charCodingConfig;
    private HttpProcessor httpProcessor;
    private ConnectionReuseStrategy connStrategy;
    private HttpResponseFactory<ClassicHttpResponse> responseFactory;
    private ServerSocketFactory serverSocketFactory;
    private SSLContext sslContext;
    private Callback<SSLParameters> sslSetupHandler;
    private HttpConnectionFactory<? extends DefaultBHttpServerConnection> connectionFactory;
    private ExceptionListener exceptionListener;
    private Http1StreamListener streamListener;
    private BiFunction<String, URIAuthority, URIAuthority> authorityResolver;

    private ServerBootstrap() {
    }

    public static ServerBootstrap bootstrap() {
        return new ServerBootstrap();
    }

    public final ServerBootstrap setCanonicalHostName(String canonicalHostName) {
        this.canonicalHostName = canonicalHostName;
        return this;
    }

    public final ServerBootstrap setListenerPort(int listenerPort) {
        this.listenerPort = listenerPort;
        return this;
    }

    public final ServerBootstrap setLocalAddress(InetAddress localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    public final ServerBootstrap setSocketConfig(SocketConfig socketConfig) {
        this.socketConfig = socketConfig;
        return this;
    }

    public final ServerBootstrap setHttp1Config(Http1Config http1Config) {
        this.http1Config = http1Config;
        return this;
    }

    public final ServerBootstrap setCharCodingConfig(CharCodingConfig charCodingConfig) {
        this.charCodingConfig = charCodingConfig;
        return this;
    }

    public final ServerBootstrap setHttpProcessor(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    public final ServerBootstrap setConnectionReuseStrategy(ConnectionReuseStrategy connStrategy) {
        this.connStrategy = connStrategy;
        return this;
    }

    public final ServerBootstrap setResponseFactory(HttpResponseFactory<ClassicHttpResponse> responseFactory) {
        this.responseFactory = responseFactory;
        return this;
    }

    @Deprecated
    public final ServerBootstrap setLookupRegistry(LookupRegistry<HttpRequestHandler> lookupRegistry) {
        this.lookupRegistry = lookupRegistry;
        return this;
    }

    public final ServerBootstrap register(String uriPattern, HttpRequestHandler requestHandler) {
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(requestHandler, "Supplier");
        this.routeEntries.add(new RequestRouter.Entry<HttpRequestHandler>(uriPattern, requestHandler));
        return this;
    }

    public final ServerBootstrap register(String hostname, String uriPattern, HttpRequestHandler requestHandler) {
        Args.notBlank(hostname, "Hostname");
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(requestHandler, "Request handler");
        this.routeEntries.add(new RequestRouter.Entry<HttpRequestHandler>(hostname, uriPattern, requestHandler));
        return this;
    }

    @Deprecated
    public final ServerBootstrap registerVirtual(String hostname, String uriPattern, HttpRequestHandler requestHandler) {
        return this.register(hostname, uriPattern, requestHandler);
    }

    public final ServerBootstrap setRequestRouter(HttpRequestMapper<HttpRequestHandler> requestRouter) {
        this.requestRouter = requestRouter;
        return this;
    }

    public final ServerBootstrap setConnectionFactory(HttpConnectionFactory<? extends DefaultBHttpServerConnection> connectionFactory) {
        this.connectionFactory = connectionFactory;
        return this;
    }

    public final ServerBootstrap setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
        return this;
    }

    public final ServerBootstrap setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public final ServerBootstrap setSslSetupHandler(Callback<SSLParameters> sslSetupHandler) {
        this.sslSetupHandler = sslSetupHandler;
        return this;
    }

    public final ServerBootstrap setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
        return this;
    }

    public final ServerBootstrap setStreamListener(Http1StreamListener streamListener) {
        this.streamListener = streamListener;
        return this;
    }

    public final ServerBootstrap setAuthorityResolver(BiFunction<String, URIAuthority, URIAuthority> authorityResolver) {
        this.authorityResolver = authorityResolver;
        return this;
    }

    public final ServerBootstrap addFilterBefore(String existing, String name, HttpFilterHandler filterHandler) {
        Args.notBlank(existing, "Existing");
        Args.notBlank(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<HttpFilterHandler>(FilterEntry.Position.BEFORE, name, filterHandler, existing));
        return this;
    }

    public final ServerBootstrap addFilterAfter(String existing, String name, HttpFilterHandler filterHandler) {
        Args.notBlank(existing, "Existing");
        Args.notBlank(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<HttpFilterHandler>(FilterEntry.Position.AFTER, name, filterHandler, existing));
        return this;
    }

    public final ServerBootstrap replaceFilter(String existing, HttpFilterHandler filterHandler) {
        Args.notBlank(existing, "Existing");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<HttpFilterHandler>(FilterEntry.Position.REPLACE, existing, filterHandler, existing));
        return this;
    }

    public final ServerBootstrap addFilterFirst(String name, HttpFilterHandler filterHandler) {
        Args.notNull(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<HttpFilterHandler>(FilterEntry.Position.FIRST, name, filterHandler, null));
        return this;
    }

    public final ServerBootstrap addFilterLast(String name, HttpFilterHandler filterHandler) {
        Args.notNull(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<HttpFilterHandler>(FilterEntry.Position.LAST, name, filterHandler, null));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpServer create() {
        void var5_12;
        HttpServerRequestHandler requestHandler;
        HttpRequestMapper<HttpRequestHandler> requestRouterCopy;
        String actualCanonicalHostName;
        String string = actualCanonicalHostName = this.canonicalHostName != null ? this.canonicalHostName : InetAddressUtils.getCanonicalLocalHostName();
        if (this.lookupRegistry != null && this.requestRouter == null) {
            RequestHandlerRegistry<HttpRequestHandler> handlerRegistry = new RequestHandlerRegistry<HttpRequestHandler>(actualCanonicalHostName, () -> this.lookupRegistry != null ? this.lookupRegistry : new UriPatternMatcher());
            for (RequestRouter.Entry<HttpRequestHandler> entry : this.routeEntries) {
                handlerRegistry.register(entry.uriAuthority != null ? entry.uriAuthority.getHostName() : null, (String)entry.route.pattern, (HttpRequestHandler)entry.route.handler);
            }
            requestRouterCopy = handlerRegistry;
        } else {
            requestRouterCopy = this.routeEntries.isEmpty() ? this.requestRouter : RequestRouter.create(new URIAuthority(actualCanonicalHostName), UriPatternType.URI_PATTERN, this.routeEntries, this.authorityResolver != null ? this.authorityResolver : RequestRouter.IGNORE_PORT_AUTHORITY_RESOLVER, this.requestRouter);
        }
        if (!this.filters.isEmpty()) {
            void var6_16;
            void var5_7;
            NamedElementChain<HttpFilterHandler> filterChainDefinition = new NamedElementChain<HttpFilterHandler>();
            filterChainDefinition.addLast(new TerminalServerFilter(requestRouterCopy, this.responseFactory != null ? this.responseFactory : DefaultClassicHttpResponseFactory.INSTANCE), StandardFilter.MAIN_HANDLER.name());
            filterChainDefinition.addFirst(new HttpServerExpectationFilter(), StandardFilter.EXPECT_CONTINUE.name());
            for (FilterEntry<HttpFilterHandler> filterEntry : this.filters) {
                switch (filterEntry.position) {
                    case AFTER: {
                        filterChainDefinition.addAfter(filterEntry.existing, (HttpFilterHandler)filterEntry.filterHandler, filterEntry.name);
                        break;
                    }
                    case BEFORE: {
                        filterChainDefinition.addBefore(filterEntry.existing, (HttpFilterHandler)filterEntry.filterHandler, filterEntry.name);
                        break;
                    }
                    case REPLACE: {
                        filterChainDefinition.replace(filterEntry.existing, (HttpFilterHandler)filterEntry.filterHandler);
                        break;
                    }
                    case FIRST: {
                        filterChainDefinition.addFirst((HttpFilterHandler)filterEntry.filterHandler, filterEntry.name);
                        break;
                    }
                    case LAST: {
                        filterChainDefinition.addBefore(StandardFilter.MAIN_HANDLER.name(), (HttpFilterHandler)filterEntry.filterHandler, filterEntry.name);
                    }
                }
            }
            NamedElementChain.Node node = filterChainDefinition.getLast();
            Object var6_15 = null;
            while (var5_7 != null) {
                HttpServerFilterChainElement httpServerFilterChainElement = new HttpServerFilterChainElement((HttpFilterHandler)var5_7.getValue(), (HttpServerFilterChainElement)var6_16);
                NamedElementChain.Node node2 = var5_7.getPrevious();
            }
            requestHandler = new HttpServerFilterChainRequestHandler((HttpServerFilterChainElement)var6_16);
        } else {
            requestHandler = new BasicHttpServerExpectationDecorator(new BasicHttpServerRequestHandler(requestRouterCopy, this.responseFactory != null ? this.responseFactory : DefaultClassicHttpResponseFactory.INSTANCE));
        }
        HttpService httpService = new HttpService(this.httpProcessor != null ? this.httpProcessor : HttpProcessors.server(), requestHandler, this.http1Config, this.connStrategy != null ? this.connStrategy : DefaultConnectionReuseStrategy.INSTANCE, this.streamListener);
        HttpConnectionFactory<? extends DefaultBHttpServerConnection> httpConnectionFactory = this.connectionFactory;
        if (httpConnectionFactory == null) {
            String string2 = this.serverSocketFactory instanceof SSLServerSocketFactory || this.sslContext != null ? URIScheme.HTTPS.id : URIScheme.HTTP.id;
            DefaultBHttpServerConnectionFactory defaultBHttpServerConnectionFactory = new DefaultBHttpServerConnectionFactory(string2, this.http1Config, this.charCodingConfig);
        }
        return new HttpServer(Math.max(this.listenerPort, 0), httpService, this.localAddress, this.socketConfig != null ? this.socketConfig : SocketConfig.DEFAULT, this.serverSocketFactory, (HttpConnectionFactory<? extends DefaultBHttpServerConnection>)var5_12, this.sslContext, this.sslSetupHandler != null ? this.sslSetupHandler : DefaultTlsSetupHandler.SERVER, this.exceptionListener != null ? this.exceptionListener : ExceptionListener.NO_OP);
    }
}

