/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.configuration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.zjsonpatch.JsonDiff;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.configuration.SecurityConfigVersionDocument;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;

public class SecurityConfigDiffCalculator {
    private static final Logger LOGGER = LogManager.getLogger(SecurityConfigDiffCalculator.class);
    private static final ObjectMapper objectMapper = DefaultObjectMapper.objectMapper;

    public static boolean hasSecurityConfigChanged(Map<String, SecurityConfigVersionDocument.HistoricSecurityConfig<?>> oldConfig, Map<String, SecurityConfigVersionDocument.HistoricSecurityConfig<?>> newConfig) {
        try {
            JsonNode newNode;
            if (oldConfig == null || oldConfig.isEmpty()) {
                LOGGER.info("Old configuration is empty. Treating as a new configuration.");
                return true;
            }
            JsonNode oldNode = SecurityConfigDiffCalculator.buildConfigDataNode(oldConfig);
            JsonNode diff = JsonDiff.asJson((JsonNode)oldNode, (JsonNode)(newNode = SecurityConfigDiffCalculator.buildConfigDataNode(newConfig)));
            if (diff.isEmpty()) {
                LOGGER.info("No changes detected in security configuration.");
                return false;
            }
            LOGGER.info("Detected changes in security configuration: {}", (Object)diff.toString());
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error while comparing security configurations", (Throwable)e);
            return false;
        }
    }

    private static JsonNode buildConfigDataNode(Map<String, SecurityConfigVersionDocument.HistoricSecurityConfig<?>> configMap) {
        TreeMap structuredConfigData = new TreeMap();
        if (configMap == null) {
            return objectMapper.createObjectNode();
        }
        for (Map.Entry<String, SecurityConfigVersionDocument.HistoricSecurityConfig<?>> configEntry : configMap.entrySet()) {
            Map<String, SecurityDynamicConfiguration<?>> configData;
            String type = configEntry.getKey();
            SecurityConfigVersionDocument.HistoricSecurityConfig<?> securityConfig = configEntry.getValue();
            if (securityConfig == null || (configData = securityConfig.getConfigData()) == null) continue;
            TreeMap extractedCEntriesPerType = new TreeMap();
            for (Map.Entry<String, SecurityDynamicConfiguration<?>> configDataEntry : configData.entrySet()) {
                String configName = configDataEntry.getKey();
                SecurityDynamicConfiguration<?> dynamicConfig = configDataEntry.getValue();
                if (dynamicConfig instanceof SecurityDynamicConfiguration) {
                    SecurityDynamicConfiguration<?> dynConf = dynamicConfig;
                    if (dynConf.getCEntries() == null) continue;
                    extractedCEntriesPerType.put(configName, new TreeMap(dynConf.getCEntries()));
                    continue;
                }
                try {
                    Map serializedMap = (Map)objectMapper.convertValue(dynamicConfig, Map.class);
                    extractedCEntriesPerType.put(configName, new TreeMap(serializedMap));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to serialize unexpected config type for {}: {}", (Object)configName, (Object)dynamicConfig.getClass().getName(), (Object)e);
                }
            }
            structuredConfigData.put(type, extractedCEntriesPerType);
        }
        return objectMapper.valueToTree(structuredConfigData);
    }
}

