/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.exactsearch;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.opensearch.common.Nullable;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.query.exactsearch.ExactKNNIterator;
import org.opensearch.knn.index.vectorvalues.KNNBinaryVectorValues;

class BinaryVectorIdsExactKNNIterator
implements ExactKNNIterator {
    protected final DocIdSetIterator docIdSetIterator;
    protected final byte[] queryVector;
    protected final KNNBinaryVectorValues binaryVectorValues;
    protected final SpaceType spaceType;
    protected float currentScore = Float.NEGATIVE_INFINITY;
    protected int docId;

    public BinaryVectorIdsExactKNNIterator(@Nullable DocIdSetIterator docIdSetIterator, byte[] queryVector, KNNBinaryVectorValues binaryVectorValues, SpaceType spaceType) throws IOException {
        this.docIdSetIterator = docIdSetIterator;
        this.queryVector = queryVector;
        this.binaryVectorValues = binaryVectorValues;
        this.spaceType = spaceType;
        this.docId = this.getNextDocId();
    }

    public BinaryVectorIdsExactKNNIterator(byte[] queryVector, KNNBinaryVectorValues binaryVectorValues, SpaceType spaceType) throws IOException {
        this(null, queryVector, binaryVectorValues, spaceType);
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.docId == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        this.currentScore = this.computeScore();
        int currentDocId = this.docId;
        this.docId = this.getNextDocId();
        return currentDocId;
    }

    @Override
    public float score() {
        return this.currentScore;
    }

    protected float computeScore() throws IOException {
        byte[] vector = this.binaryVectorValues.getVector();
        return this.spaceType.getKnnVectorSimilarityFunction().compare(this.queryVector, vector);
    }

    protected int getNextDocId() throws IOException {
        if (this.docIdSetIterator == null) {
            return this.binaryVectorValues.nextDoc();
        }
        int nextDocID = this.docIdSetIterator.nextDoc();
        if (nextDocID != Integer.MAX_VALUE) {
            this.binaryVectorValues.advance(nextDocID);
        }
        return nextDocID;
    }
}

