/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical.datasource;

import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.planner.DefaultImplementor;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.datasource.DataSourceTableScan;
import org.opensearch.sql.planner.physical.datasource.DataSourceTableSchema;
import org.opensearch.sql.storage.Table;
import shaded.com.google.common.annotations.VisibleForTesting;

public class DataSourceTable
implements Table {
    private final DataSourceService dataSourceService;

    @Override
    public Map<String, ExprType> getFieldTypes() {
        return DataSourceTableSchema.DATASOURCE_TABLE_SCHEMA.getMapping();
    }

    @Override
    public PhysicalPlan implement(LogicalPlan plan) {
        return plan.accept(new DataSourceTableDefaultImplementor(this.dataSourceService), null);
    }

    @Generated
    public DataSourceTable(DataSourceService dataSourceService) {
        this.dataSourceService = dataSourceService;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceTable)) {
            return false;
        }
        DataSourceTable other = (DataSourceTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DataSourceService this$dataSourceService = this.dataSourceService;
        DataSourceService other$dataSourceService = other.dataSourceService;
        return !(this$dataSourceService == null ? other$dataSourceService != null : !this$dataSourceService.equals(other$dataSourceService));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataSourceTable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataSourceService $dataSourceService = this.dataSourceService;
        result = result * 59 + ($dataSourceService == null ? 43 : $dataSourceService.hashCode());
        return result;
    }

    @VisibleForTesting
    public static class DataSourceTableDefaultImplementor
    extends DefaultImplementor<Object> {
        private final DataSourceService dataSourceService;

        @Override
        public PhysicalPlan visitRelation(LogicalRelation node, Object context) {
            return new DataSourceTableScan(this.dataSourceService);
        }

        @Generated
        public DataSourceTableDefaultImplementor(DataSourceService dataSourceService) {
            this.dataSourceService = dataSourceService;
        }
    }
}

