/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.checkpoint;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.support.replication.ReplicationRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.indices.replication.checkpoint.RemoteStoreMergedSegmentCheckpoint;

public class RemoteStorePublishMergedSegmentRequest
extends ReplicationRequest<RemoteStorePublishMergedSegmentRequest> {
    private final RemoteStoreMergedSegmentCheckpoint mergedSegment;

    public RemoteStorePublishMergedSegmentRequest(RemoteStoreMergedSegmentCheckpoint mergedSegment) {
        super(mergedSegment.getShardId());
        this.mergedSegment = mergedSegment;
    }

    public RemoteStorePublishMergedSegmentRequest(StreamInput in) throws IOException {
        super(in);
        this.mergedSegment = new RemoteStoreMergedSegmentCheckpoint(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.mergedSegment.writeTo(out);
    }

    public int hashCode() {
        return Objects.hash(this.mergedSegment);
    }

    @Override
    public String toString() {
        return "RemoteStorePublishMergedSegmentRequest{mergedSegment=" + String.valueOf(this.mergedSegment) + "}";
    }

    public RemoteStoreMergedSegmentCheckpoint getMergedSegment() {
        return this.mergedSegment;
    }
}

