/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query.functionscore;

import java.util.ArrayList;
import org.opensearch.common.lucene.search.function.CombineFunction;
import org.opensearch.common.lucene.search.function.FunctionScoreQuery;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilder;
import org.opensearch.index.query.functionscore.WeightBuilder;
import org.opensearch.protobufs.FunctionBoostMode;
import org.opensearch.protobufs.FunctionScoreContainer;
import org.opensearch.protobufs.FunctionScoreMode;
import org.opensearch.protobufs.FunctionScoreQuery;
import org.opensearch.protobufs.QueryContainer;
import org.opensearch.transport.grpc.proto.request.search.query.functionscore.ExpDecayFunctionProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.query.functionscore.FieldValueFactorFunctionProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.query.functionscore.GaussDecayFunctionProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.query.functionscore.LinearDecayFunctionProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.query.functionscore.RandomScoreFunctionProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.query.functionscore.ScriptScoreFunctionProtoUtils;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverterRegistry;

class FunctionScoreQueryBuilderProtoUtils {
    private FunctionScoreQueryBuilderProtoUtils() {
    }

    static FunctionScoreQueryBuilder fromProto(FunctionScoreQuery functionScoreQueryProto, QueryBuilderProtoConverterRegistry registry) {
        if (functionScoreQueryProto == null) {
            throw new IllegalArgumentException("FunctionScoreQuery cannot be null");
        }
        QueryBuilder query = null;
        float boost = 1.0f;
        String queryName = null;
        FunctionScoreQuery.ScoreMode scoreMode = FunctionScoreQueryBuilder.DEFAULT_SCORE_MODE;
        float maxBoost = Float.MAX_VALUE;
        Float minScore = null;
        CombineFunction combineFunction = null;
        ArrayList<FunctionScoreQueryBuilder.FilterFunctionBuilder> filterFunctionBuilders = new ArrayList<FunctionScoreQueryBuilder.FilterFunctionBuilder>();
        if (functionScoreQueryProto.hasQuery()) {
            QueryContainer queryContainer = functionScoreQueryProto.getQuery();
            query = registry.fromProto(queryContainer);
        }
        if (functionScoreQueryProto.getFunctionsCount() > 0) {
            for (FunctionScoreContainer container : functionScoreQueryProto.getFunctionsList()) {
                FunctionScoreQueryBuilder.FilterFunctionBuilder filterFunctionBuilder = FunctionScoreQueryBuilderProtoUtils.parseFunctionScoreContainer(container, registry);
                filterFunctionBuilders.add(filterFunctionBuilder);
            }
        }
        if (query == null) {
            query = new MatchAllQueryBuilder();
        }
        FunctionScoreQueryBuilder functionScoreQueryBuilder = new FunctionScoreQueryBuilder(query, filterFunctionBuilders.toArray(new FunctionScoreQueryBuilder.FilterFunctionBuilder[0]));
        if (functionScoreQueryProto.hasBoostMode() && functionScoreQueryProto.getBoostMode() != FunctionBoostMode.FUNCTION_BOOST_MODE_UNSPECIFIED) {
            combineFunction = FunctionScoreQueryBuilderProtoUtils.parseBoostMode(functionScoreQueryProto.getBoostMode());
        }
        if (functionScoreQueryProto.hasScoreMode() && functionScoreQueryProto.getScoreMode() != FunctionScoreMode.FUNCTION_SCORE_MODE_UNSPECIFIED) {
            scoreMode = FunctionScoreQueryBuilderProtoUtils.parseScoreMode(functionScoreQueryProto.getScoreMode());
        }
        if (functionScoreQueryProto.hasMaxBoost()) {
            maxBoost = functionScoreQueryProto.getMaxBoost();
        }
        if (functionScoreQueryProto.hasMinScore()) {
            minScore = Float.valueOf(functionScoreQueryProto.getMinScore());
        }
        if (functionScoreQueryProto.hasBoost()) {
            boost = functionScoreQueryProto.getBoost();
        }
        if (functionScoreQueryProto.hasXName()) {
            queryName = functionScoreQueryProto.getXName();
        }
        functionScoreQueryBuilder.boost(boost);
        if (queryName != null) {
            functionScoreQueryBuilder.queryName(queryName);
        }
        functionScoreQueryBuilder.scoreMode(scoreMode);
        functionScoreQueryBuilder.maxBoost(maxBoost);
        if (minScore != null) {
            functionScoreQueryBuilder.setMinScore(minScore.floatValue());
        }
        if (combineFunction != null) {
            functionScoreQueryBuilder.boostMode(combineFunction);
        }
        return functionScoreQueryBuilder;
    }

    private static FunctionScoreQueryBuilder.FilterFunctionBuilder parseFunctionScoreContainer(FunctionScoreContainer container, QueryBuilderProtoConverterRegistry registry) {
        if (container == null) {
            throw new IllegalArgumentException("FunctionScoreContainer cannot be null");
        }
        QueryBuilder filter = null;
        ScoreFunctionBuilder scoreFunction = null;
        Float functionWeight = null;
        if (container.hasFilter()) {
            QueryContainer filterContainer = container.getFilter();
            filter = registry.fromProto(filterContainer);
        }
        if (container.hasWeight()) {
            functionWeight = Float.valueOf(container.getWeight());
        }
        scoreFunction = container.getFunctionScoreContainerCase() == FunctionScoreContainer.FunctionScoreContainerCase.FUNCTIONSCORECONTAINER_NOT_SET ? null : FunctionScoreQueryBuilderProtoUtils.parseScoreFunction(container);
        if (functionWeight != null) {
            if (scoreFunction == null) {
                scoreFunction = new WeightBuilder().setWeight(functionWeight.floatValue());
            } else {
                scoreFunction.setWeight(functionWeight.floatValue());
            }
        }
        if (filter == null) {
            filter = new MatchAllQueryBuilder();
        }
        return new FunctionScoreQueryBuilder.FilterFunctionBuilder(filter, scoreFunction);
    }

    private static ScoreFunctionBuilder<?> parseScoreFunction(FunctionScoreContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("FunctionScoreContainer cannot be null");
        }
        FunctionScoreContainer.FunctionScoreContainerCase functionCase = container.getFunctionScoreContainerCase();
        return switch (functionCase) {
            case FunctionScoreContainer.FunctionScoreContainerCase.FIELD_VALUE_FACTOR -> FieldValueFactorFunctionProtoUtils.fromProto(container.getFieldValueFactor());
            case FunctionScoreContainer.FunctionScoreContainerCase.RANDOM_SCORE -> RandomScoreFunctionProtoUtils.fromProto(container.getRandomScore());
            case FunctionScoreContainer.FunctionScoreContainerCase.SCRIPT_SCORE -> ScriptScoreFunctionProtoUtils.fromProto(container.getScriptScore());
            case FunctionScoreContainer.FunctionScoreContainerCase.EXP -> ExpDecayFunctionProtoUtils.fromProto(container.getExp());
            case FunctionScoreContainer.FunctionScoreContainerCase.GAUSS -> GaussDecayFunctionProtoUtils.fromProto(container.getGauss());
            case FunctionScoreContainer.FunctionScoreContainerCase.LINEAR -> LinearDecayFunctionProtoUtils.fromProto(container.getLinear());
            default -> throw new IllegalArgumentException("Unsupported function score type: " + String.valueOf(functionCase));
        };
    }

    private static CombineFunction parseBoostMode(FunctionBoostMode boostMode) {
        return switch (boostMode) {
            case FunctionBoostMode.FUNCTION_BOOST_MODE_AVG -> CombineFunction.AVG;
            case FunctionBoostMode.FUNCTION_BOOST_MODE_MAX -> CombineFunction.MAX;
            case FunctionBoostMode.FUNCTION_BOOST_MODE_MIN -> CombineFunction.MIN;
            case FunctionBoostMode.FUNCTION_BOOST_MODE_MULTIPLY -> CombineFunction.MULTIPLY;
            case FunctionBoostMode.FUNCTION_BOOST_MODE_REPLACE -> CombineFunction.REPLACE;
            case FunctionBoostMode.FUNCTION_BOOST_MODE_SUM -> CombineFunction.SUM;
            default -> throw new IllegalArgumentException("Unsupported boost mode: " + String.valueOf(boostMode));
        };
    }

    private static FunctionScoreQuery.ScoreMode parseScoreMode(FunctionScoreMode scoreMode) {
        return switch (scoreMode) {
            case FunctionScoreMode.FUNCTION_SCORE_MODE_AVG -> FunctionScoreQuery.ScoreMode.AVG;
            case FunctionScoreMode.FUNCTION_SCORE_MODE_FIRST -> FunctionScoreQuery.ScoreMode.FIRST;
            case FunctionScoreMode.FUNCTION_SCORE_MODE_MAX -> FunctionScoreQuery.ScoreMode.MAX;
            case FunctionScoreMode.FUNCTION_SCORE_MODE_MIN -> FunctionScoreQuery.ScoreMode.MIN;
            case FunctionScoreMode.FUNCTION_SCORE_MODE_MULTIPLY -> FunctionScoreQuery.ScoreMode.MULTIPLY;
            case FunctionScoreMode.FUNCTION_SCORE_MODE_SUM -> FunctionScoreQuery.ScoreMode.SUM;
            default -> throw new IllegalArgumentException("Unsupported score mode: " + String.valueOf(scoreMode));
        };
    }
}

