/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.js;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import org.keycloak.scripting.EvaluatableScriptAdapter;

public class ScriptCache {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final Map<String, CacheEntry> cache;
    private final AtomicBoolean writing = new AtomicBoolean(false);
    private final long maxAge;

    public ScriptCache(int maxEntries) {
        this(maxEntries, -1L);
    }

    public ScriptCache(final int maxEntries, long maxAge) {
        this.cache = Collections.synchronizedMap(new LinkedHashMap<String, CacheEntry>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return ScriptCache.this.cache.size() > maxEntries;
            }
        });
        this.maxAge = maxAge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvaluatableScriptAdapter computeIfAbsent(String id, Function<String, EvaluatableScriptAdapter> function) {
        try {
            EvaluatableScriptAdapter adapter = this.removeIfExpired(this.cache.get(id));
            if (adapter != null) {
                EvaluatableScriptAdapter evaluatableScriptAdapter = adapter;
                return evaluatableScriptAdapter;
            }
            if (this.parkForWriteAndCheckInterrupt()) {
                EvaluatableScriptAdapter evaluatableScriptAdapter = null;
                return evaluatableScriptAdapter;
            }
            CacheEntry entry = this.cache.computeIfAbsent(id, (? super K key) -> new CacheEntry((String)key, (EvaluatableScriptAdapter)function.apply(id), this.maxAge));
            if (entry != null) {
                EvaluatableScriptAdapter evaluatableScriptAdapter = entry.value();
                return evaluatableScriptAdapter;
            }
            EvaluatableScriptAdapter evaluatableScriptAdapter = null;
            return evaluatableScriptAdapter;
        }
        finally {
            this.writing.lazySet(false);
        }
    }

    public void remove(String key) {
        try {
            if (this.parkForWriteAndCheckInterrupt()) {
                return;
            }
            this.cache.remove(key);
        }
        finally {
            this.writing.lazySet(false);
        }
    }

    private EvaluatableScriptAdapter removeIfExpired(CacheEntry cached) {
        if (cached == null) {
            return null;
        }
        if (cached.isExpired()) {
            this.remove(cached.key());
            return null;
        }
        return cached.value();
    }

    private boolean parkForWriteAndCheckInterrupt() {
        while (!this.writing.compareAndSet(false, true)) {
            LockSupport.parkNanos(1L);
            if (!Thread.interrupted()) continue;
            return true;
        }
        return false;
    }

    private static final class CacheEntry {
        final String key;
        final EvaluatableScriptAdapter value;
        final long expiration;

        CacheEntry(String key, EvaluatableScriptAdapter value, long maxAge) {
            this.key = key;
            this.value = value;
            this.expiration = maxAge == -1L ? -1L : System.currentTimeMillis() + maxAge;
        }

        String key() {
            return this.key;
        }

        EvaluatableScriptAdapter value() {
            return this.value;
        }

        boolean isExpired() {
            return this.expiration != -1L ? System.currentTimeMillis() > this.expiration : false;
        }
    }
}

