/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.xml;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.dialect.function.json.ExpressionTypeHelper;
import org.hibernate.dialect.function.xml.XmlAggFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SelfRenderingOrderedSetAggregateFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SelfRenderingSqmOrderedSetAggregateFunction;
import org.hibernate.query.sqm.spi.SqmCreationHelper;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.AbstractSqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.FunctionExpression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.from.FunctionTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.type.spi.TypeConfiguration;

public class SQLServerXmlAggFunction
extends XmlAggFunction {
    public SQLServerXmlAggFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
    }

    @Override
    public <T> SelfRenderingSqmOrderedSetAggregateFunction<T> generateSqmOrderedSetAggregateFunctionExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, SqmOrderByClause withinGroupClause, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        return new SelfRenderingSqmOrderedSetAggregateFunction<T>(this, this, arguments, filter, withinGroupClause, impliedResultType, this.getArgumentsValidator(), this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName()){

            @Override
            public Expression convertToSqlAst(SqmToSqlAstConverter walker) {
                SelfRenderingOrderedSetAggregateFunctionSqlAstExpression expression = (SelfRenderingOrderedSetAggregateFunctionSqlAstExpression)super.convertToSqlAst(walker);
                Expression xml = (Expression)expression.getArguments().get(0);
                Set<String> qualifiers = ColumnQualifierCollectorSqlAstWalker.determineColumnQualifiers(xml);
                if (!qualifiers.isEmpty()) {
                    walker.registerQueryTransformer((cteContainer, querySpec, converter) -> {
                        TableGroup tableGroup = querySpec.getFromClause().queryTableGroups(tg -> {
                            String primaryVariable = tg.getPrimaryTableReference().getIdentificationVariable();
                            if (qualifiers.contains(primaryVariable)) {
                                return tg;
                            }
                            for (TableReferenceJoin tableReferenceJoin : tg.getTableReferenceJoins()) {
                                String variable = tableReferenceJoin.getJoinedTableReference().getIdentificationVariable();
                                if (!qualifiers.contains(variable)) continue;
                                return tg;
                            }
                            return null;
                        });
                        if (tableGroup != null) {
                            String alias = "gen" + SqmCreationHelper.acquireUniqueAlias();
                            FunctionTableGroup lateralGroup = new FunctionTableGroup(new NavigablePath("generated", alias), null, new SelfRenderingFunctionSqlAstExpression("helper", (sqlAppender, sqlAstArguments, returnType, walker1) -> {
                                sqlAppender.appendSql("(select ");
                                xml.accept(walker1);
                                sqlAppender.appendSql(" v)");
                            }, List.of(), null, null), alias, List.of("v"), Set.of(), true, true, false, null);
                            tableGroup.addTableGroupJoin(new TableGroupJoin(lateralGroup.getNavigablePath(), SqlAstJoinType.INNER, lateralGroup));
                            expression.getArguments().set(0, new ColumnReference(lateralGroup.getPrimaryTableReference(), "v", expression.getJdbcMapping()));
                        }
                        return querySpec;
                    });
                }
                return expression;
            }
        };
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, List<SortSpecification> withinGroup, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        Expression arg;
        boolean caseWrapper = filter != null && !SQLServerXmlAggFunction.filterClauseSupported(translator);
        sqlAppender.appendSql("cast(string_agg(");
        SqlAstNode firstArg = sqlAstArguments.get(0);
        if (firstArg instanceof Distinct) {
            Distinct distinct = (Distinct)firstArg;
            sqlAppender.appendSql("distinct ");
            arg = distinct.getExpression();
        } else {
            arg = (Expression)firstArg;
        }
        boolean needsCast = ExpressionTypeHelper.isXml(arg);
        if (needsCast) {
            sqlAppender.appendSql("cast(");
        }
        if (caseWrapper) {
            translator.getCurrentClauseStack().push(Clause.WHERE);
            sqlAppender.appendSql("case when ");
            filter.accept(translator);
            sqlAppender.appendSql(" then ");
            arg.accept(translator);
            sqlAppender.appendSql(" else null end");
            translator.getCurrentClauseStack().pop();
        } else {
            arg.accept(translator);
        }
        if (needsCast) {
            sqlAppender.appendSql(" as nvarchar(max))");
        }
        sqlAppender.appendSql(",'')");
        if (withinGroup != null && !withinGroup.isEmpty()) {
            translator.getCurrentClauseStack().push(Clause.WITHIN_GROUP);
            sqlAppender.appendSql(" within group (order by ");
            withinGroup.get(0).accept(translator);
            for (int i = 1; i < withinGroup.size(); ++i) {
                sqlAppender.appendSql(',');
                withinGroup.get(i).accept(translator);
            }
            sqlAppender.appendSql(')');
            translator.getCurrentClauseStack().pop();
        }
        if (!caseWrapper && filter != null) {
            translator.getCurrentClauseStack().push(Clause.WHERE);
            sqlAppender.appendSql(" filter (where ");
            filter.accept(translator);
            sqlAppender.appendSql(')');
            translator.getCurrentClauseStack().pop();
        }
        sqlAppender.appendSql(" as xml)");
    }

    static class ColumnQualifierCollectorSqlAstWalker
    extends AbstractSqlAstWalker {
        private static final Set<String> POTENTIAL_SUBQUERY_FUNCTIONS = Set.of("xmlelement", "xmlforest");
        private final Set<String> columnQualifiers = new HashSet<String>();
        private boolean potentialSubquery;

        ColumnQualifierCollectorSqlAstWalker() {
        }

        public static Set<String> determineColumnQualifiers(SqlAstNode node) {
            ColumnQualifierCollectorSqlAstWalker walker = new ColumnQualifierCollectorSqlAstWalker();
            node.accept(walker);
            return walker.potentialSubquery ? walker.columnQualifiers : Set.of();
        }

        @Override
        public void visitSelfRenderingExpression(SelfRenderingExpression expression) {
            FunctionExpression functionExpression;
            if (expression instanceof FunctionExpression && POTENTIAL_SUBQUERY_FUNCTIONS.contains((functionExpression = (FunctionExpression)((Object)expression)).getFunctionName())) {
                this.potentialSubquery = true;
            }
            super.visitSelfRenderingExpression(expression);
        }

        @Override
        public void visitColumnReference(ColumnReference columnReference) {
            if (columnReference.getQualifier() != null) {
                this.columnQualifiers.add(columnReference.getQualifier());
            }
        }
    }
}

