/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import org.jmol.symmetry.CIPChirality;
import org.jmol.symmetry.CIPData;
import org.jmol.viewer.JC;

public class CIPDataTracker
extends CIPData {
    public Map<String, CIPTracker> htTracker = new Hashtable<String, CIPTracker>();
    private int lastIndex = -1;
    private Map<String, Object> lastInfo;

    @Override
    protected boolean isTracker() {
        return true;
    }

    @Override
    void track(CIPChirality cip, CIPChirality.CIPAtom a, CIPChirality.CIPAtom b, int sphere, int finalScore, boolean trackTerminal) {
        CIPChirality.CIPAtom b1;
        CIPChirality.CIPAtom a1;
        if (a == null || b == null || a.rootSubstituent == b.rootSubstituent) {
            return;
        }
        if (finalScore > 0) {
            a1 = b;
            b1 = a;
        } else {
            a1 = a;
            b1 = b;
        }
        CIPTracker t = new CIPTracker(cip.currentRule, a1, b1, sphere, Math.abs(finalScore), trackTerminal);
        this.htTracker.put(CIPDataTracker.getTrackerKey(cip.root, a1, b1), t);
    }

    @Override
    String getRootTrackerResult(CIPChirality.CIPAtom root) {
        String s = "";
        for (int i = 0; i < 3; ++i) {
            s = s + "\t" + root.atoms[i] + "\t--------------\n";
            CIPTracker t = this.htTracker.get(CIPDataTracker.getTrackerKey(root, root.atoms[i], root.atoms[i + 1]));
            if (t == null) continue;
            int n = Math.max(t.bsa.length(), t.bsb.length());
            s = s + t.getTrackerLine(t.a, t.bsa, t.rule == 8 ? t.a.listRS[2] : null, n);
            s = s + "\t   " + JC.getCIPRuleName(t.rule) + "\n";
            s = s + t.getTrackerLine(t.b, t.bsb, t.rule == 8 ? t.b.listRS[2] : null, n);
        }
        s = s + "\t" + root.atoms[3] + "\t--------------\n";
        System.out.println(root + "\n\n" + s);
        this.setCIPInfo(s, root.atom.getIndex(), root.atom.getAtomName());
        return s;
    }

    private void setCIPInfo(String s, int index, String name) {
        Map<String, Object> modelInfo = this.getModelAuxiliaryInfoForAtom(index);
        if (modelInfo != null) {
            Hashtable<String, String> cipInfo = (Hashtable<String, String>)modelInfo.get("CIPInfo");
            if (cipInfo == null) {
                cipInfo = new Hashtable<String, String>();
                modelInfo.put("CIPInfo", cipInfo);
            }
            cipInfo.put(name, s);
        }
    }

    private Map<String, Object> getModelAuxiliaryInfoForAtom(int index) {
        Map<String, Object> map;
        if (index == this.lastIndex) {
            map = this.lastInfo;
        } else {
            this.lastIndex = index;
            map = this.lastInfo = this.vwr.ms.getModelAuxiliaryInfo(this.vwr.ms.at[this.lastIndex].getModelIndex());
        }
        return map;
    }

    private static String getTrackerKey(CIPChirality.CIPAtom root, CIPChirality.CIPAtom a, CIPChirality.CIPAtom b) {
        return b.rootSubstituent == null ? "" : root.atom.getAtomName() + "." + a.rootSubstituent.atom.getAtomName() + "-" + b.rootSubstituent.atom.getAtomName();
    }

    class CIPTracker {
        CIPChirality.CIPAtom a;
        CIPChirality.CIPAtom b;
        int sphere;
        int score;
        int rule;
        public BS bsa;
        public BS bsb;
        private boolean trackTerminal;

        CIPTracker(int rule, CIPChirality.CIPAtom a, CIPChirality.CIPAtom b, int sphere, int score, boolean trackTerminal) {
            this.rule = rule;
            this.a = a;
            this.b = b;
            this.sphere = sphere;
            this.score = score;
            this.trackTerminal = trackTerminal;
            this.bsa = a.listRS == null ? new BS() : a.listRS[0];
            this.bsb = b.listRS == null ? new BS() : b.listRS[0];
        }

        String getTrackerLine(CIPChirality.CIPAtom b, BS bsb, BS bsS, int n) {
            return "\t\t" + b.myPath + (!this.trackTerminal ? "" : (b.isTerminal ? "-o" : "-" + b.atoms[0].atom.getAtomName())) + (this.rule != 8 && bsb.length() == 0 ? "" : "\t" + this.getLikeUnlike(bsb, b.listRS, n) + (bsS == null ? "" : "  " + this.getLikeUnlike(bsS, b.listRS, -n))) + "\n";
        }

        private String getLikeUnlike(BS bsa, BS[] listRS, int n) {
            if (this.rule != 8 && this.rule != 6) {
                return "";
            }
            String s = n > 0 && (this.rule == 8 || bsa == listRS[1]) ? "(R)" : "(S)";
            n = Math.abs(n);
            for (int i = 0; i < n; ++i) {
                s = s + (bsa.get(i) ? "l" : "u");
            }
            return s;
        }
    }
}

