/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ComponentMetadataListerDetails;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.repositories.descriptor.UrlRepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.metadata.ImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataArtifactProvider;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataSource;
import org.gradle.api.internal.artifacts.repositories.resolver.DefaultExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MetadataFetchingCost;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourceVersionLister;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.DefaultModuleDescriptorArtifactMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleDescriptorArtifactMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.result.BuildableArtifactFileResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;
import org.gradle.internal.resolve.result.BuildableTypedResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.local.ByteArrayReadableContent;
import org.gradle.internal.resource.local.FileReadableContent;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.gradle.util.internal.CollectionUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExternalResourceResolver
implements ConfiguredModuleComponentRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalResourceResolver.class);
    private final String name;
    private final ImmutableList<ResourcePattern> ivyPatterns;
    private final ImmutableList<ResourcePattern> artifactPatterns;
    private ComponentResolvers componentResolvers;
    private final ExternalResourceRepository repository;
    private final boolean local;
    private final CacheAwareExternalResourceAccessor cachingResourceAccessor;
    private final LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder;
    private final FileStore<ModuleComponentArtifactIdentifier> artifactFileStore;
    private final ImmutableMetadataSources metadataSources;
    private final MetadataArtifactProvider metadataArtifactProvider;
    private final InstantiatingAction<ComponentMetadataSupplierDetails> componentMetadataSupplierFactory;
    private final InstantiatingAction<ComponentMetadataListerDetails> providedVersionLister;
    private final Instantiator injector;
    private final ChecksumService checksumService;
    private final boolean continueOnConnectionFailure;
    private final String id;
    private ExternalResourceArtifactResolver cachedArtifactResolver;

    protected ExternalResourceResolver(UrlRepositoryDescriptor descriptor, boolean local, ExternalResourceRepository repository, CacheAwareExternalResourceAccessor cachingResourceAccessor, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, ImmutableMetadataSources metadataSources, MetadataArtifactProvider metadataArtifactProvider, @Nullable InstantiatingAction<ComponentMetadataSupplierDetails> componentMetadataSupplierFactory, @Nullable InstantiatingAction<ComponentMetadataListerDetails> providedVersionLister, Instantiator injector, ChecksumService checksumService, boolean continueOnConnectionFailure) {
        this.id = descriptor.getId();
        this.name = descriptor.getName();
        this.ivyPatterns = descriptor.getMetadataResources();
        this.artifactPatterns = descriptor.getArtifactResources();
        this.local = local;
        this.cachingResourceAccessor = cachingResourceAccessor;
        this.repository = repository;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.artifactFileStore = artifactFileStore;
        this.metadataSources = metadataSources;
        this.metadataArtifactProvider = metadataArtifactProvider;
        this.componentMetadataSupplierFactory = componentMetadataSupplierFactory;
        this.providedVersionLister = providedVersionLister;
        this.injector = injector;
        this.checksumService = checksumService;
        this.continueOnConnectionFailure = continueOnConnectionFailure;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDynamicResolveMode() {
        return false;
    }

    @Override
    public boolean isContinueOnConnectionFailure() {
        return this.continueOnConnectionFailure;
    }

    @Override
    public boolean isRepositoryDisabled() {
        return false;
    }

    @Override
    public void setComponentResolvers(ComponentResolvers resolver) {
        this.componentResolvers = resolver;
    }

    protected ExternalResourceRepository getRepository() {
        return this.repository;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public Instantiator getComponentMetadataInstantiator() {
        return this.injector;
    }

    @Override
    public InstantiatingAction<ComponentMetadataSupplierDetails> getComponentMetadataSupplier() {
        return this.componentMetadataSupplierFactory;
    }

    @VisibleForTesting
    public InstantiatingAction<ComponentMetadataListerDetails> getProvidedVersionLister() {
        return this.providedVersionLister;
    }

    @Override
    public Map<ComponentArtifactIdentifier, ResolvableArtifact> getArtifactCache() {
        throw new UnsupportedOperationException();
    }

    private void doListModuleVersions(ModuleComponentSelector selector, ComponentOverrideMetadata overrideMetadata, BuildableModuleVersionListingResolveResult result) {
        ModuleIdentifier module = selector.getModuleIdentifier();
        this.tryListingViaRule(module, result);
        if (result.hasResult() && result.isAuthoritative()) {
            return;
        }
        ResourceVersionLister versionLister = new ResourceVersionLister(this.repository);
        List<ResourcePattern> completeIvyPatterns = this.filterComplete((List<ResourcePattern>)this.ivyPatterns, module);
        List<ResourcePattern> completeArtifactPatterns = this.filterComplete((List<ResourcePattern>)this.artifactPatterns, module);
        for (MetadataSource metadataSource : this.metadataSources.sources()) {
            metadataSource.listModuleVersions(selector, overrideMetadata, completeIvyPatterns, completeArtifactPatterns, versionLister, result);
            if (!result.hasResult() || !result.isAuthoritative()) continue;
            return;
        }
        result.listed((Collection<String>)ImmutableSet.of());
    }

    private void tryListingViaRule(ModuleIdentifier module, BuildableModuleVersionListingResolveResult result) {
        if (this.providedVersionLister != null) {
            this.providedVersionLister.execute((Object)new DefaultComponentVersionsLister(module, result));
        }
    }

    private List<ResourcePattern> filterComplete(List<ResourcePattern> ivyPatterns, ModuleIdentifier module) {
        return CollectionUtils.filter(ivyPatterns, element -> element.isComplete(module));
    }

    protected void doResolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata prescribedMetaData, BuildableModuleComponentMetaDataResolveResult<ModuleComponentResolveMetadata> result) {
        this.resolveStaticDependency(moduleComponentIdentifier, prescribedMetaData, result, this.createArtifactResolver());
    }

    protected final void resolveStaticDependency(ModuleComponentIdentifier moduleVersionIdentifier, ComponentOverrideMetadata prescribedMetaData, BuildableModuleComponentMetaDataResolveResult<ModuleComponentResolveMetadata> result, ExternalResourceArtifactResolver artifactResolver) {
        for (MetadataSource source : this.metadataSources.sources()) {
            Object value = source.create(this.name, this.componentResolvers, moduleVersionIdentifier, prescribedMetaData, artifactResolver, result);
            if (value == null) continue;
            this.maybeDisableComponentMetadataRuleCaching((MutableModuleComponentResolveMetadata)value);
            result.resolved(value.asImmutable());
            return;
        }
        LOGGER.debug("No meta-data file or artifact found for module '{}' in repository '{}'.", (Object)moduleVersionIdentifier, (Object)this.getName());
        result.missing();
    }

    private void maybeDisableComponentMetadataRuleCaching(MutableModuleComponentResolveMetadata value) {
        if (this.isLocal()) {
            value.setComponentMetadataRuleCachingEnabled(false);
        }
    }

    protected abstract boolean isMetaDataArtifact(ArtifactType var1);

    protected Set<ModuleComponentArtifactMetadata> findOptionalArtifacts(ComponentArtifactResolveMetadata module, String type, String classifier) {
        if (!(module.getId() instanceof ModuleComponentIdentifier)) {
            return Collections.emptySet();
        }
        ModuleComponentIdentifier moduleId = (ModuleComponentIdentifier)module.getId();
        DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(moduleId.getModule(), type, "jar", classifier);
        DefaultModuleComponentArtifactMetadata artifact = new DefaultModuleComponentArtifactMetadata(moduleId, ivyArtifactName);
        if (this.createArtifactResolver(module.getSources()).artifactExists(artifact, new DefaultResourceAwareResolveResult())) {
            return ImmutableSet.of((Object)artifact);
        }
        return Collections.emptySet();
    }

    private ModuleDescriptorArtifactMetadata getMetaDataArtifactFor(ModuleComponentIdentifier moduleComponentIdentifier) {
        IvyArtifactName ivyArtifactName = this.metadataArtifactProvider.getMetaDataArtifactName(moduleComponentIdentifier.getModule());
        return new DefaultModuleDescriptorArtifactMetadata(moduleComponentIdentifier, ivyArtifactName);
    }

    protected ExternalResourceArtifactResolver createArtifactResolver() {
        ExternalResourceArtifactResolver artifactResolver;
        if (this.cachedArtifactResolver != null) {
            return this.cachedArtifactResolver;
        }
        this.cachedArtifactResolver = artifactResolver = this.createArtifactResolver((List<ResourcePattern>)this.ivyPatterns, (List<ResourcePattern>)this.artifactPatterns);
        return artifactResolver;
    }

    private ExternalResourceArtifactResolver createArtifactResolver(List<ResourcePattern> ivyPatterns, List<ResourcePattern> artifactPatterns) {
        return new DefaultExternalResourceArtifactResolver(this.repository, this.locallyAvailableResourceFinder, ivyPatterns, artifactPatterns, this.artifactFileStore, this.cachingResourceAccessor);
    }

    protected ExternalResourceArtifactResolver createArtifactResolver(ModuleSources moduleSources) {
        return this.createArtifactResolver();
    }

    public void publish(ModuleComponentArtifactMetadata artifact, File src) {
        ResourcePattern destinationPattern;
        if ("ivy".equals(artifact.getName().getType()) && !this.ivyPatterns.isEmpty()) {
            destinationPattern = (ResourcePattern)this.ivyPatterns.get(0);
        } else if (!this.artifactPatterns.isEmpty()) {
            destinationPattern = (ResourcePattern)this.artifactPatterns.get(0);
        } else {
            throw new IllegalStateException("impossible to publish " + artifact + " using " + this + ": no artifact pattern defined");
        }
        ExternalResourceName destination = destinationPattern.getLocation(artifact);
        this.put(src, destination);
        LOGGER.info("Published {} to {}", (Object)artifact, (Object)destination);
    }

    private void put(File src, ExternalResourceName destination) {
        this.repository.withProgressLogging().resource(destination).put((ReadableContent)new FileReadableContent(src));
        this.publishChecksums(destination, src);
    }

    private void publishChecksums(ExternalResourceName destination, File content) {
        this.publishChecksum(destination, content, "sha1");
        if (!ExternalResourceResolver.disableExtraChecksums()) {
            this.publishPossiblyUnsupportedChecksum(destination, content, "sha-256");
            this.publishPossiblyUnsupportedChecksum(destination, content, "sha-512");
        }
    }

    private void publishPossiblyUnsupportedChecksum(ExternalResourceName destination, File content, String algorithm) {
        try {
            this.publishChecksum(destination, content, algorithm);
        }
        catch (Exception ex) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn("Cannot upload checksum for " + content.getName() + " because the remote repository doesn't support " + algorithm + ". This will not fail the build.", (Throwable)ex);
            }
            LOGGER.warn("Cannot upload checksum for " + content.getName() + " because the remote repository doesn't support " + algorithm + ". This will not fail the build.");
        }
    }

    private void publishChecksum(ExternalResourceName destination, File content, String algorithm) {
        byte[] checksum = this.createChecksumFile(content, algorithm.toUpperCase(Locale.ROOT));
        ExternalResourceName checksumDestination = destination.append("." + algorithm.replaceAll("-", ""));
        this.repository.resource(checksumDestination).put((ReadableContent)new ByteArrayReadableContent(checksum));
    }

    private byte[] createChecksumFile(File src, String algorithm) {
        HashCode hash = this.checksumService.hash(src, algorithm);
        String formattedHashString = hash.toString();
        try {
            return formattedHashString.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public List<String> getIvyPatterns() {
        return CollectionUtils.collect(this.ivyPatterns, ResourcePattern::getPattern);
    }

    public List<String> getArtifactPatterns() {
        return CollectionUtils.collect(this.artifactPatterns, ResourcePattern::getPattern);
    }

    public static boolean disableExtraChecksums() {
        return Boolean.getBoolean("org.gradle.internal.publish.checksums.insecure");
    }

    private static class DefaultComponentVersionsLister
    implements ComponentMetadataListerDetails {
        private final ModuleIdentifier id;
        private final BuildableModuleVersionListingResolveResult result;

        private DefaultComponentVersionsLister(ModuleIdentifier id, BuildableModuleVersionListingResolveResult result) {
            this.id = id;
            this.result = result;
        }

        public ModuleIdentifier getModuleIdentifier() {
            return this.id;
        }

        public void listed(List<String> versions) {
            this.result.listed(versions);
        }
    }

    private static class NoOpResourceAwareResolveResult
    implements ResourceAwareResolveResult {
        private static final NoOpResourceAwareResolveResult INSTANCE = new NoOpResourceAwareResolveResult();

        private NoOpResourceAwareResolveResult() {
        }

        @Override
        public List<String> getAttempted() {
            return Collections.emptyList();
        }

        @Override
        public void attempted(String locationDescription) {
        }

        @Override
        public void attempted(ExternalResourceName location) {
        }

        @Override
        public void applyTo(ResourceAwareResolveResult target) {
            throw new UnsupportedOperationException();
        }
    }

    protected abstract class RemoteRepositoryAccess
    extends AbstractRepositoryAccess {
        protected RemoteRepositoryAccess() {
        }

        public String toString() {
            return "remote > " + ExternalResourceResolver.this;
        }

        @Override
        public final void listModuleVersions(ModuleComponentSelector selector, ComponentOverrideMetadata overrideMetadata, BuildableModuleVersionListingResolveResult result) {
            ExternalResourceResolver.this.doListModuleVersions(selector, overrideMetadata, result);
        }

        @Override
        public final void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult<ModuleComponentResolveMetadata> result) {
            ExternalResourceResolver.this.doResolveComponentMetaData(moduleComponentIdentifier, requestMetaData, result);
        }

        @Override
        public void resolveArtifactsWithType(ComponentArtifactResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            super.resolveArtifactsWithType(component, artifactType, result);
            this.checkArtifactsResolved(component, artifactType, result);
        }

        private void checkArtifactsResolved(ComponentArtifactResolveMetadata component, Object context, BuildableTypedResolveResult<?, ? super ArtifactResolveException> result) {
            if (!result.hasResult()) {
                result.failed(new ArtifactResolveException(component.getId(), String.format("Cannot locate %s for '%s' in repository '%s'", context, component.getId().getDisplayName(), ExternalResourceResolver.this.name)));
            }
        }

        @Override
        protected final void resolveMetaDataArtifacts(ComponentArtifactResolveMetadata module, BuildableArtifactSetResolveResult result) {
        }

        @Override
        protected void resolveJavadocArtifacts(ComponentArtifactResolveMetadata module, BuildableArtifactSetResolveResult result) {
            result.resolved(ExternalResourceResolver.this.findOptionalArtifacts(module, "javadoc", "javadoc"));
        }

        @Override
        protected void resolveSourceArtifacts(ComponentArtifactResolveMetadata module, BuildableArtifactSetResolveResult result) {
            result.resolved(ExternalResourceResolver.this.findOptionalArtifacts(module, "source", "sources"));
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSources moduleSources, BuildableArtifactFileResolveResult result) {
            if (artifact.isOptionalArtifact() && artifact instanceof ModuleComponentArtifactMetadata) {
                if (!ExternalResourceResolver.this.createArtifactResolver(moduleSources).artifactExists((ModuleComponentArtifactMetadata)artifact, new DefaultResourceAwareResolveResult())) {
                    result.notFound(artifact.getId());
                    return;
                }
            } else if (artifact.getAlternativeArtifact().isPresent()) {
                DefaultResourceAwareResolveResult checkForArtifact = new DefaultResourceAwareResolveResult();
                if (!ExternalResourceResolver.this.createArtifactResolver(moduleSources).artifactExists((ModuleComponentArtifactMetadata)artifact, checkForArtifact)) {
                    checkForArtifact.getAttempted().forEach(result::attempted);
                    this.resolveArtifact(artifact.getAlternativeArtifact().get(), moduleSources, result);
                    return;
                }
            }
            try {
                ExternalResourceArtifactResolver resolver = ExternalResourceResolver.this.createArtifactResolver(moduleSources);
                ModuleComponentArtifactMetadata moduleArtifact = (ModuleComponentArtifactMetadata)artifact;
                LocallyAvailableExternalResource artifactResource = resolver.resolveArtifact(moduleArtifact, result);
                if (artifactResource == null) {
                    result.notFound(artifact.getId());
                } else {
                    result.resolved(artifactResource.getFile());
                }
            }
            catch (Exception e) {
                result.failed(new ArtifactResolveException(artifact.getId(), (Throwable)e));
            }
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            if (ExternalResourceResolver.this.local) {
                ModuleDescriptorArtifactMetadata artifact = ExternalResourceResolver.this.getMetaDataArtifactFor(moduleComponentIdentifier);
                if (ExternalResourceResolver.this.createArtifactResolver().artifactExists(artifact, NoOpResourceAwareResolveResult.INSTANCE)) {
                    return MetadataFetchingCost.FAST;
                }
                return MetadataFetchingCost.CHEAP;
            }
            return MetadataFetchingCost.EXPENSIVE;
        }
    }

    protected abstract class LocalRepositoryAccess
    extends AbstractRepositoryAccess {
        protected LocalRepositoryAccess() {
        }

        public String toString() {
            return "local > " + ExternalResourceResolver.this;
        }

        @Override
        public final void listModuleVersions(ModuleComponentSelector selector, ComponentOverrideMetadata overrideMetadata, BuildableModuleVersionListingResolveResult result) {
        }

        @Override
        public final void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult<ModuleComponentResolveMetadata> result) {
        }

        @Override
        protected final void resolveMetaDataArtifacts(ComponentArtifactResolveMetadata module, BuildableArtifactSetResolveResult result) {
            if (!(module.getId() instanceof ModuleComponentIdentifier)) {
                return;
            }
            ModuleComponentIdentifier moduleId = (ModuleComponentIdentifier)module.getId();
            ModuleDescriptorArtifactMetadata artifact = ExternalResourceResolver.this.getMetaDataArtifactFor(moduleId);
            result.resolved(Collections.singleton(artifact));
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSources moduleSources, BuildableArtifactFileResolveResult result) {
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            return MetadataFetchingCost.CHEAP;
        }
    }

    protected abstract class AbstractRepositoryAccess
    implements ModuleComponentRepositoryAccess<ModuleComponentResolveMetadata> {
        protected AbstractRepositoryAccess() {
        }

        @Override
        public void resolveArtifactsWithType(ComponentArtifactResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            if (artifactType == ArtifactType.JAVADOC) {
                this.resolveJavadocArtifacts(component, result);
            } else if (artifactType == ArtifactType.SOURCES) {
                this.resolveSourceArtifacts(component, result);
            } else if (ExternalResourceResolver.this.isMetaDataArtifact(artifactType)) {
                this.resolveMetaDataArtifacts(component, result);
            }
        }

        protected abstract void resolveMetaDataArtifacts(ComponentArtifactResolveMetadata var1, BuildableArtifactSetResolveResult var2);

        protected abstract void resolveJavadocArtifacts(ComponentArtifactResolveMetadata var1, BuildableArtifactSetResolveResult var2);

        protected abstract void resolveSourceArtifacts(ComponentArtifactResolveMetadata var1, BuildableArtifactSetResolveResult var2);
    }
}

