/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import tim.prune.data.DataPoint;
import tim.prune.data.MarkingData;
import tim.prune.data.Track;

public class TrackDetails {
    private final Track _track;
    private double _trackSpan = -1.0;
    private double _trackRadians = -1.0;
    private boolean[] _segmentStarts = null;
    private boolean[] _segmentEnds = null;
    private boolean[] _waypoints = null;
    private double _meanRadians = 0.0;

    public TrackDetails(Track track) {
        this._track = track;
    }

    public void initialise() {
        double d = this._track.getXRange().getRange();
        double d2 = this._track.getYRange().getRange();
        this._trackSpan = Math.max(d, d2);
        this._trackRadians = TrackDetails.calculateMaxRadians(this._track);
        int n = this._track.getNumPoints();
        this._segmentStarts = new boolean[n];
        this._segmentEnds = new boolean[n];
        this._waypoints = new boolean[n];
        int n2 = -1;
        int n3 = 0;
        double d3 = 0.0;
        int n4 = 0;
        while (n4 < n) {
            DataPoint dataPoint = this._track.getPoint(n4);
            if (!dataPoint.isWaypoint()) {
                if (dataPoint.getSegmentStart()) {
                    this._segmentStarts[n4] = true;
                    if (n2 >= 0) {
                        this._segmentEnds[n2] = true;
                    }
                } else if (n2 >= 0) {
                    ++n3;
                    d3 += DataPoint.calculateRadiansBetween(this._track.getPoint(n2), dataPoint);
                }
                n2 = n4;
                this._waypoints[n4] = false;
            } else {
                this._waypoints[n4] = true;
            }
            ++n4;
        }
        if (n2 >= 0) {
            this._segmentEnds[n2] = true;
        }
        this._meanRadians = d3 / (double)n3;
    }

    private static double calculateMaxRadians(Track track) {
        double d;
        DataPoint dataPoint = null;
        DataPoint dataPoint2 = null;
        DataPoint dataPoint3 = null;
        DataPoint dataPoint4 = null;
        int n = 0;
        while (n < track.getNumPoints()) {
            DataPoint dataPoint5 = track.getPoint(n);
            if (!dataPoint5.isWaypoint()) {
                d = dataPoint5.getLatitude().getDouble();
                if (dataPoint == null || dataPoint.getLatitude().getDouble() < d) {
                    dataPoint = dataPoint5;
                }
                if (dataPoint2 == null || dataPoint2.getLatitude().getDouble() > d) {
                    dataPoint2 = dataPoint5;
                }
                double d2 = dataPoint5.getLongitude().getDouble();
                if (dataPoint3 == null || dataPoint3.getLongitude().getDouble() > d2) {
                    dataPoint3 = dataPoint5;
                }
                if (dataPoint4 == null || dataPoint4.getLongitude().getDouble() < d2) {
                    dataPoint4 = dataPoint5;
                }
            }
            ++n;
        }
        if (dataPoint == null || dataPoint2 == null || dataPoint4 == null || dataPoint3 == null) {
            return 1.0;
        }
        double d3 = DataPoint.calculateRadiansBetween(dataPoint, dataPoint2);
        d = DataPoint.calculateRadiansBetween(dataPoint4, dataPoint3);
        return Math.max(d3, d);
    }

    public double getTrackSpan() {
        if (this._trackSpan < 0.0) {
            this.initialise();
        }
        return this._trackSpan;
    }

    public double getMaxRadians() {
        if (this._trackRadians < 0.0) {
            this.initialise();
        }
        return this._trackRadians;
    }

    public boolean isSegmentStart(int n) {
        if (this._segmentStarts == null || this._segmentStarts.length != this._track.getNumPoints()) {
            this.initialise();
        }
        return this._segmentStarts[n];
    }

    public boolean isSegmentEnd(int n) {
        if (this._segmentEnds == null || this._segmentEnds.length != this._track.getNumPoints()) {
            this.initialise();
        }
        return this._segmentEnds[n];
    }

    public double getMeanRadians() {
        if (this._meanRadians == 0.0) {
            this.initialise();
        }
        return this._meanRadians;
    }

    public boolean isWaypoint(int n) {
        if (this._waypoints == null || this._waypoints.length != this._track.getNumPoints()) {
            this.initialise();
        }
        return this._waypoints[n];
    }

    public TrackDetails modifyUsingMarkings(MarkingData markingData) {
        this.initialise();
        TrackDetails trackDetails = new TrackDetails(this._track);
        trackDetails.initialise();
        int n = this._track.getNumPoints();
        int n2 = -1;
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            DataPoint dataPoint = this._track.getPoint(n3);
            if (!dataPoint.isWaypoint()) {
                if (markingData.isPointMarkedForDeletion(n3)) {
                    bl = bl || this._segmentStarts[n3] || dataPoint.getSegmentStart() || markingData.isPointMarkedForSegmentBreak(n3);
                } else {
                    if (bl) {
                        trackDetails._segmentStarts[n3] = true;
                        if (n2 >= 0) {
                            trackDetails._segmentEnds[n2] = true;
                        }
                        bl = false;
                    }
                    n2 = n3;
                }
            }
            ++n3;
        }
        if (n2 >= 0) {
            trackDetails._segmentEnds[n2] = true;
        }
        return trackDetails;
    }
}

