---
stage: none
group: Tutorials
info: For assistance with this tutorials page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
description: AI-native features and workflows.
title: 'Tutorials: GitLab Duo'
---

Use AI-native features in GitLab to enhance your workflows across the software development lifecycle.

## Ask GitLab Duo Chat (Agentic)

Chat interactively and get immediate feedback.

| Topic | Description | Good for beginners | Try it out |
|-------|-------------|--------------------|------------|
| [Getting started](https://about.gitlab.com/blog/getting-started-with-gitlab-duo-agentic-chat/) | Get set up to use Agentic Chat and try out some common use cases. | {{< icon name="star" >}} | [Explore the interface](https://gitlab.navattic.com/duo-agentic-chat) |
| [Manage issues with GitLab Duo Chat](duo_chat_issues/_index.md) | Get familiar with the GitLab Duo Chat interface, and try out some issue management tasks. | {{< icon name="star" >}} | |
| [Use GitLab Duo to make a web application](../user/gitlab_duo/tutorials/fix_code_python_shop.md) | Use Chat and Code Suggestions to build a Python web application. | {{< icon name="star" >}} | |
| [Use GitLab Duo to fix a web application](../user/gitlab_duo/tutorials/duo_python_fix_errors.md) | Write and run test cases for your web application, and implement error handling and data validation. | | |

## Work with agents and flows

Deploy AI assistants to complete tasks and handle complex workflows for you.

| Topic | Description | Good for beginners | Try it out |
|-------|-------------|--------------------|------------|
| [Understanding agents: Foundational, custom, and external](https://about.gitlab.com/blog/understanding-agents-foundational-custom-external/) | Learn what the different types of agents do, and create your own custom agents. | {{< icon name="star" >}} | [Configure a custom agent](https://gitlab.navattic.com/custom-agents)|
| [Understanding flows: Multi-agent workflows](https://about.gitlab.com/blog/understanding-flows-multi-agent-workflows/) | Learn about the types of flows, and create your own custom flows. | {{< icon name="star" >}} | [Configure a custom flow](https://gitlab.navattic.com/custom-flows)|

## Extend and integrate

Extend GitLab Duo capabilities by connecting with external tools.

| Topic | Description | Good for beginners | Try it out |
|-------|-------------|--------------------|------------|
| [Model Context Protocol integration](https://about.gitlab.com/blog/duo-agent-platform-with-mcp/) | Discover how MCP can help you connect GitLab Duo features to external sources, and connect AI tools to your GitLab instance. | | Explore the [client workflow](https://gitlab.navattic.com/mcp) and [server workflow](https://gitlab.navattic.com/gitlab-mcp-server)|
