---
stage: Software Supply Chain Security
group: Compliance
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: コンプライアンスの概要ダッシュボード
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 18.2で`compliance_group_dashboard`フラグとともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/13909)されました。デフォルトでは有効になっています。
- GitLab 18.3で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/555804)になりました。機能フラグ`compliance_group_dashboard`は削除されました。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。この機能はテストには利用できますが、本番環境での使用には適していません。

{{< /alert >}}

コンプライアンスのダッシュボードの概要は、インタラクティブなチャートとメトリクスを通じて、グループのコンプライアンス体制に関する視覚的なインサイトを提供します。注意が必要な領域を迅速に特定し、全体的なコンプライアンス状況を追跡するのに役立ちます。

コンプライアンスの概要ダッシュボードには、コンプライアンスのモニタリングの4つの主要領域が表示されます:

- コンプライアンスフレームワークのカバレッジ。
- 失敗した要件のステータス。
- 失敗したコントロールのステータス。
- 注意が必要なコンプライアンスフレームワーク。

## コンプライアンスのダッシュボードを表示する {#view-the-compliance-overview-dashboard}

前提要件: 

- グループの管理者であるか、オーナーロールを持っている必要があります。

コンプライアンス概要ダッシュボードを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **セキュリティ** > **コンプライアンスセンター**を選択します。
1. **概要**を選択して、コンプライアンスダッシュボードを表示します。

## コンプライアンスフレームワークのカバレッジ {#compliance-framework-coverage}

フレームワークのカバレッジセクションでは、グループ内のプロジェクトのうち、いくつにコンプライアンスフレームワークが割り当てられているかの概要がわかります。

フレームワークのカバレッジセクションには、以下が表示されます:

- **プロジェクト全体**: グループ内のプロジェクトの総数。
- **Covered projects**（対象プロジェクト）: 少なくとも1つのコンプライアンスフレームワークが割り当てられているプロジェクトの数。
- **Coverage percentage**（カバレッジ）の割合: プロジェクト全体のフレームワークのカバレッジを視覚的に表現。

サマリーメトリクスの下には、以下を含む個々のフレームワークのカバレッジが表示されます:

- ビジュアルバッジ付きのフレームワーク名。
- 各フレームワークを使用しているプロジェクトの数。
- 各フレームワークでカバレッジされるプロジェクトの合計の割合。

## 失敗した要件チャート {#failed-requirements-chart}

失敗した要件チャートは、フレームワーク全体の要件のコンプライアンス状況を視覚化します。

失敗した要件チャートには、3つのカテゴリが表示されます:

- **成功**: 完全にコンプライアンスに準拠している要件（青色で表示）。
- **保留中**: レビュー中の要件（オレンジ色で表示）。
- **失敗**: コンプライアンス標準を満たしていない要件（マゼンタで表示）。

## 失敗したコントロールチャート {#failed-controls-chart}

失敗したコントロールチャートは、組織全体のコントロールのコンプライアンス状況を視覚的に表現したものです。

失敗したコントロールチャートには、3つのカテゴリが表示されます:

- **成功**: コンプライアンス要件を満たすコントロール（青色で表示）。
- **保留中**: 評価待ちのコントロール（オレンジ色で表示）。
- **失敗**: コンプライアンス要件を満たさないコントロール（マゼンタで表示）。

## フレームワークテーブル {#frameworks-table}

フレームワークテーブルは、早急な対応が必要なコンプライアンスフレームワークを強調表示します。このビューは、設定の問題または不足しているコンポーネントがあるフレームワークを特定するのに役立ちます。

フレームワークテーブルには、以下が表示されます:

- **フレームワーク名**: ビジュアルバッジ付きのコンプライアンスフレームワーク。
- **プロジェクト**: このフレームワークを使用しているプロジェクトの数（ゼロの場合は赤で強調表示）。
- **要求**: フレームワーク内の要件の総数（ゼロの場合は赤で強調表示）。
- **制御なしの要件**: 関連するコントロールがない特定の要件を一覧表示します。
- **ポリシー**: 以下を含む、フレームワークにリンクされたセキュリティポリシー:
  - スキャン実行ポリシー。
  - 脆弱性管理ポリシー。
  - スキャン結果ポリシー。
  - パイプライン実行ポリシー。
- **アクション**: フレームワークの編集ボタン（管理者権限を持つユーザーに表示）。
