/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.bcb;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathEvent;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathListener;

public class BreadcrumbBarModel<T> {
    private LinkedList<BreadcrumbItem<T>> items = new LinkedList();
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean isCumulative = false;
    protected int smallestCumulativeIndex = -1;

    public int indexOf(BreadcrumbItem<T> item) {
        return this.items.indexOf(item);
    }

    public void removeLast() {
        this.items.removeLast();
        this.firePathChanged(this.items.size());
    }

    public void reset() {
        this.items.clear();
        this.firePathChanged(0);
    }

    public List<BreadcrumbItem<T>> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public BreadcrumbItem<T> getItem(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.getItemCount()) {
            return null;
        }
        return this.items.get(index);
    }

    public void replace(List<BreadcrumbItem<T>> items) {
        this.items.clear();
        for (int i = 0; i < items.size(); ++i) {
            this.items.addLast(items.get(i));
        }
        this.firePathChanged(0);
    }

    public void addLast(BreadcrumbItem<T> item) {
        this.items.addLast(item);
        this.firePathChanged(this.items.size() - 1);
    }

    public void setCumulative(boolean isCumulative) {
        boolean toFire = this.isCumulative && !isCumulative;
        this.isCumulative = isCumulative;
        if (toFire) {
            this.firePathChanged(Math.max(0, this.smallestCumulativeIndex));
            this.smallestCumulativeIndex = -1;
        }
    }

    public void addPathListener(BreadcrumbPathListener l) {
        this.listenerList.add(BreadcrumbPathListener.class, l);
    }

    public void removePathListener(BreadcrumbPathListener l) {
        this.listenerList.remove(BreadcrumbPathListener.class, l);
    }

    protected void firePathChanged(int indexOfFirstChange) {
        if (this.isCumulative) {
            this.smallestCumulativeIndex = this.smallestCumulativeIndex == -1 ? indexOfFirstChange : Math.min(this.smallestCumulativeIndex, indexOfFirstChange);
            return;
        }
        BreadcrumbPathEvent event = new BreadcrumbPathEvent(this, indexOfFirstChange);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != BreadcrumbPathListener.class) continue;
            ((BreadcrumbPathListener)listeners[i + 1]).breadcrumbPathEvent(event);
        }
    }
}

