/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import com.topografix.gpx._1._0.Gpx;
import java.io.File;
import java.util.List;
import org.fibs.geotag.tasks.BackgroundTask;
import org.fibs.geotag.track.GpxOneOneReader;
import org.fibs.geotag.track.GpxReader;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class GpxReadFileTask
extends BackgroundTask<Gpx> {
    private static final I18n i18n = I18nFactory.getI18n(GpxReadFileTask.class);
    private File[] files;
    private int trackPointsFound = 0;

    public GpxReadFileTask(String name, File[] files) {
        super(name);
        this.files = files;
    }

    @Override
    public int getCurrentProgress() {
        return 0;
    }

    @Override
    public int getMaxProgress() {
        return 0;
    }

    @Override
    public int getMinProgress() {
        return 0;
    }

    @Override
    protected String doInBackground() throws Exception {
        File[] fileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            Gpx gpx = null;
            try {
                gpx = GpxReader.read(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (gpx == null) {
                try {
                    gpx = GpxOneOneReader.read(file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.publish(gpx);
            if (gpx != null) {
                List<Gpx.Trk> tracks = gpx.getTrk();
                for (Gpx.Trk trk : tracks) {
                    List<Gpx.Trk.Trkseg> segments = trk.getTrkseg();
                    for (Gpx.Trk.Trkseg segment : segments) {
                        this.trackPointsFound += segment.getTrkpt().size();
                    }
                }
            }
            ++n2;
        }
        String message = String.valueOf(this.trackPointsFound) + " " + i18n.tr("locations loaded.");
        return message;
    }
}

