/**
 * SECTION:name-details
 * @short_description: Structured name representation for human names.
 * 
 * <para>Represents a full name split in its constituent parts (given name, family name, etc.). This structure corresponds to the &quot;N&quot; field in vCards. The parts of the name are never <code>null</code>: an empty string indicates that a property is not set.</para>
 *
 * Since: 0.3.5
 */
/**
 * FOLKS_TYPE_STRUCTURED_NAME:
 * 
 * The type for <link linkend="FolksStructuredName"><type>FolksStructuredName</type></link>.
 */
/**
 * folks_structured_name_is_empty:
 * @self: the <link linkend="FolksStructuredName"><type>FolksStructuredName</type></link> instance
 * 
 * Whether none of the components is set.
 * 
 * Returns: <para><code>true</code> if all the components are the empty string, <code>false</code> otherwise. </para>
 *
 * Since: 0.3.5
 */
/**
 * folks_structured_name_equal:
 * @self: the <link linkend="FolksStructuredName"><type>FolksStructuredName</type></link> instance
 * @other: (in): &nbsp;.  <para>the other structured name to compare with </para>
 * 
 * Whether two StructuredNames are the same.
 * 
 * Returns: <para><code>true</code> if all the components are the same, <code>false</code> otherwise. </para>
 *
 * Since: 0.5.0
 */
/**
 * folks_structured_name_to_string:
 * @self: the <link linkend="FolksStructuredName"><type>FolksStructuredName</type></link> instance
 * 
 * Formatted version of the structured name.
 * 
 * Returns: <para>name formatted according to the current locale </para>
 *
 * Since: 0.4.0
 */
/**
 * folks_structured_name_to_string_with_format:
 * @self: the <link linkend="FolksStructuredName"><type>FolksStructuredName</type></link> instance
 * @name_fmt: (in): &nbsp;.  <para>format string for the name </para>
 * 
 * Formatted version of the structured name.
 * 
 * <para>This allows a custom format string to be specified, using the placeholders described on <ulink url="http://lh.2xlibre.net/values/name_fmt/"></ulink>. This <code>name_fmt</code> must almost always be translated to the current locale. (Ideally it would be translated to the locale of the persona whose name is being formatted, but such locale information isn’t available.)</para>
 * 
 * Returns: <para>name formatted according to the given format </para>
 *
 * Since: 0.9.7
 */
/**
 * folks_structured_name_new:
 * @family_name: (in) (allow-none): &nbsp;.  <para>the family (last) name </para>
 * @given_name: (in) (allow-none): &nbsp;.  <para>the given (first) name </para>
 * @additional_names: (in) (allow-none): &nbsp;.  <para>additional names </para>
 * @prefixes: (in) (allow-none): &nbsp;.  <para>prefixes of the name </para>
 * @suffixes: (in) (allow-none): &nbsp;.  <para>suffixes of the name </para>
 * 
 * Create a StructuredName.
 * 
 * <para>You can pass <code>null</code> if a component is not set.</para>
 * 
 * Returns: <para>a new StructuredName </para>
 *
 * Since: 0.3.5
 */
/**
 * folks_structured_name_new_simple:
 * @family_name: (in) (allow-none): &nbsp;.  <para>the family (last) name </para>
 * @given_name: (in) (allow-none): &nbsp;.  <para>the given (first) name </para>
 * 
 * Create a StructuredName.
 * 
 * <para>Shorthand for the common case of just having the family and given name of a contact. It&apos;s equivalent to calling <link linkend="folks-structured-name-new"><function>folks_structured_name_new()</function></link> and passing <code>null</code> for all the other components.</para>
 * 
 * Returns: <para>a new StructuredName </para>
 *
 * Since: 0.3.5
 */
/**
 * FolksStructuredName:family-name:
 * 
 * The family name.
 * 
 * <para>The family name (also known as surname or last name) of a contact.</para>
 *
 * Since: 0.3.5
 */
/**
 * folks_structured_name_get_family_name:
 * @self: the <link linkend="FolksStructuredName"><type>FolksStructuredName</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksStructuredName--family-name"><type>"family-name"</type></link> property.
 * 
 * The family name.
 * 
 * <para>The family name (also known as surname or last name) of a contact.</para>
 * 
 * Returns: the value of the <link linkend="FolksStructuredName--family-name"><type>"family-name"</type></link> property
 *
 * Since: 0.3.5
 */
/**
 * folks_structured_name_set_family_name:
 * @self: the <link linkend="FolksStructuredName"><type>FolksStructuredName</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksStructuredName--family-name"><type>"family-name"</type></link> property
 * 
 * Set the value of the <link linkend="FolksStructuredName--family-name"><type>"family-name"</type></link> property to @value.
 * 
 * The family name.
 * 
 * <para>The family name (also known as surname or last name) of a contact.</para>
 *
 * Since: 0.3.5
 */
/**
 * FolksStructuredName:given-name:
 * 
 * The given name.
 * 
 * <para>The family name (also known as first name) of a contact.</para>
 *
 * Since: 0.3.5
 */
/**
 * folks_structured_name_get_given_name:
 * @self: the <link linkend="FolksStructuredName"><type>FolksStructuredName</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksStructuredName--given-name"><type>"given-name"</type></link> property.
 * 
 * The given name.
 * 
 * <para>The family name (also known as first name) of a contact.</para>
 * 
 * Returns: the value of the <link linkend="FolksStructuredName--given-name"><type>"given-name"</type></link> property
 *
 * Since: 0.3.5
 */
/**
 * folks_structured_name_set_given_name:
 * @self: the <link linkend="FolksStructuredName"><type>FolksStructuredName</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksStructuredName--given-name"><type>"given-name"</type></link> property
 * 
 * Set the value of the <link linkend="FolksStructuredName--given-name"><type>"given-name"</type></link> property to @value.
 * 
 * The given name.
 * 
 * <para>The family name (also known as first name) of a contact.</para>
 *
 * Since: 0.3.5
 */
/**
 * FolksStructuredName:additional-names:
 * 
 * Additional names.
 * 
 * <para>The additional names of a contact, for instance the contact&apos;s middle name.</para>
 *
 * Since: 0.3.5
 */
/**
 * folks_structured_name_get_additional_names:
 * @self: the <link linkend="FolksStructuredName"><type>FolksStructuredName</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksStructuredName--additional-names"><type>"additional-names"</type></link> property.
 * 
 * Additional names.
 * 
 * <para>The additional names of a contact, for instance the contact&apos;s middle name.</para>
 * 
 * Returns: the value of the <link linkend="FolksStructuredName--additional-names"><type>"additional-names"</type></link> property
 *
 * Since: 0.3.5
 */
/**
 * folks_structured_name_set_additional_names:
 * @self: the <link linkend="FolksStructuredName"><type>FolksStructuredName</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksStructuredName--additional-names"><type>"additional-names"</type></link> property
 * 
 * Set the value of the <link linkend="FolksStructuredName--additional-names"><type>"additional-names"</type></link> property to @value.
 * 
 * Additional names.
 * 
 * <para>The additional names of a contact, for instance the contact&apos;s middle name.</para>
 *
 * Since: 0.3.5
 */
/**
 * FolksStructuredName:prefixes:
 * 
 * The prefixes of a name.
 * 
 * <para>The prefixes used in front of the name (for instance &quot;Mr&quot;, &quot;Mrs&quot;, &quot;Doctor&quot; or honorific titles).</para>
 *
 * Since: 0.3.5
 */
/**
 * folks_structured_name_get_prefixes:
 * @self: the <link linkend="FolksStructuredName"><type>FolksStructuredName</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksStructuredName--prefixes"><type>"prefixes"</type></link> property.
 * 
 * The prefixes of a name.
 * 
 * <para>The prefixes used in front of the name (for instance &quot;Mr&quot;, &quot;Mrs&quot;, &quot;Doctor&quot; or honorific titles).</para>
 * 
 * Returns: the value of the <link linkend="FolksStructuredName--prefixes"><type>"prefixes"</type></link> property
 *
 * Since: 0.3.5
 */
/**
 * folks_structured_name_set_prefixes:
 * @self: the <link linkend="FolksStructuredName"><type>FolksStructuredName</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksStructuredName--prefixes"><type>"prefixes"</type></link> property
 * 
 * Set the value of the <link linkend="FolksStructuredName--prefixes"><type>"prefixes"</type></link> property to @value.
 * 
 * The prefixes of a name.
 * 
 * <para>The prefixes used in front of the name (for instance &quot;Mr&quot;, &quot;Mrs&quot;, &quot;Doctor&quot; or honorific titles).</para>
 *
 * Since: 0.3.5
 */
/**
 * FolksStructuredName:suffixes:
 * 
 * The suffixes of a name.
 * 
 * <para>The suffixes used after a name (for instance &quot;PhD&quot; or &quot;Junior&quot;).</para>
 *
 * Since: 0.3.5
 */
/**
 * folks_structured_name_get_suffixes:
 * @self: the <link linkend="FolksStructuredName"><type>FolksStructuredName</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksStructuredName--suffixes"><type>"suffixes"</type></link> property.
 * 
 * The suffixes of a name.
 * 
 * <para>The suffixes used after a name (for instance &quot;PhD&quot; or &quot;Junior&quot;).</para>
 * 
 * Returns: the value of the <link linkend="FolksStructuredName--suffixes"><type>"suffixes"</type></link> property
 *
 * Since: 0.3.5
 */
/**
 * folks_structured_name_set_suffixes:
 * @self: the <link linkend="FolksStructuredName"><type>FolksStructuredName</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksStructuredName--suffixes"><type>"suffixes"</type></link> property
 * 
 * Set the value of the <link linkend="FolksStructuredName--suffixes"><type>"suffixes"</type></link> property to @value.
 * 
 * The suffixes of a name.
 * 
 * <para>The suffixes used after a name (for instance &quot;PhD&quot; or &quot;Junior&quot;).</para>
 *
 * Since: 0.3.5
 */
/**
 * FolksStructuredName:
 * 
 * Structured name representation for human names.
 * 
 * <para>Represents a full name split in its constituent parts (given name, family name, etc.). This structure corresponds to the &quot;N&quot; field in vCards. The parts of the name are never <code>null</code>: an empty string indicates that a property is not set.</para>
 *
 * Since: 0.3.5
 */
/**
 * FolksStructuredNameClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-STRUCTURED-NAME:CAPS"><literal>FOLKS_TYPE_STRUCTURED_NAME</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * folks_name_details_change_structured_name:
 * @self: the <link linkend="FolksNameDetails"><type>FolksNameDetails</type></link> instance
 * @name: (in) (allow-none): &nbsp;.  <para>the structured name (<code>null</code> to unset it) </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s structured name.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksNameDetails--structured-name"><type>"structured-name"</type></link> directly, as this method gives error notification and will only return once the name has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the structured name failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-name-details-change-structured-name-finish"><function>folks_name_details_change_structured_name_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_name_details_change_structured_name_finish:
 * @self: the <link linkend="FolksNameDetails"><type>FolksNameDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s structured name.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksNameDetails--structured-name"><type>"structured-name"</type></link> directly, as this method gives error notification and will only return once the name has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the structured name failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-name-details-change-structured-name"><function>folks_name_details_change_structured_name()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_name_details_change_full_name:
 * @self: the <link linkend="FolksNameDetails"><type>FolksNameDetails</type></link> instance
 * @full_name: (in): &nbsp;.  <para>the full name (empty string to unset it) </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s full name.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksNameDetails--full-name"><type>"full-name"</type></link> directly, as this method gives error notification and will only return once the name has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the full name failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-name-details-change-full-name-finish"><function>folks_name_details_change_full_name_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_name_details_change_full_name_finish:
 * @self: the <link linkend="FolksNameDetails"><type>FolksNameDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s full name.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksNameDetails--full-name"><type>"full-name"</type></link> directly, as this method gives error notification and will only return once the name has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the full name failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-name-details-change-full-name"><function>folks_name_details_change_full_name()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_name_details_change_nickname:
 * @self: the <link linkend="FolksNameDetails"><type>FolksNameDetails</type></link> instance
 * @nickname: (in): &nbsp;.  <para>the nickname (empty string to unset it) </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s nickname.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksNameDetails--nickname"><type>"nickname"</type></link> directly, as this method gives error notification and will only return once the name has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the nickname failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-name-details-change-nickname-finish"><function>folks_name_details_change_nickname_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_name_details_change_nickname_finish:
 * @self: the <link linkend="FolksNameDetails"><type>FolksNameDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s nickname.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksNameDetails--nickname"><type>"nickname"</type></link> directly, as this method gives error notification and will only return once the name has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the nickname failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-name-details-change-nickname"><function>folks_name_details_change_nickname()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * FolksNameDetails:structured-name:
 * 
 * The contact name split in its constituent parts.
 * 
 * <para>Note that most of the time the structured name is not set (i.e. it&apos;s <code>null</code>) or just some of the components are set. The components are immutable. To get notification of changes of the structured name, you just have to connect to the <code>notify</code> signal of this property.</para>
 *
 * Since: 0.3.5
 */
/**
 * folks_name_details_get_structured_name:
 * @self: the <link linkend="FolksNameDetails"><type>FolksNameDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksNameDetails--structured-name"><type>"structured-name"</type></link> property.
 * 
 * The contact name split in its constituent parts.
 * 
 * <para>Note that most of the time the structured name is not set (i.e. it&apos;s <code>null</code>) or just some of the components are set. The components are immutable. To get notification of changes of the structured name, you just have to connect to the <code>notify</code> signal of this property.</para>
 * 
 * Returns: the value of the <link linkend="FolksNameDetails--structured-name"><type>"structured-name"</type></link> property
 *
 * Since: 0.3.5
 */
/**
 * folks_name_details_set_structured_name:
 * @self: the <link linkend="FolksNameDetails"><type>FolksNameDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksNameDetails--structured-name"><type>"structured-name"</type></link> property
 * 
 * Set the value of the <link linkend="FolksNameDetails--structured-name"><type>"structured-name"</type></link> property to @value.
 * 
 * The contact name split in its constituent parts.
 * 
 * <para>Note that most of the time the structured name is not set (i.e. it&apos;s <code>null</code>) or just some of the components are set. The components are immutable. To get notification of changes of the structured name, you just have to connect to the <code>notify</code> signal of this property.</para>
 *
 * Since: 0.3.5
 */
/**
 * FolksNameDetails:full-name:
 * 
 * The full name of the contact.
 * 
 * <para>The full name is the name of the contact written in the way the contact prefers. For instance for English names this is usually the given name followed by the family name, but Chinese names are usually the family name followed by the given name. The full name could or could not contain additional names (like a middle name), prefixes or suffixes.</para><para>The full name must not be <code>null</code>: the empty string represents an unset full name.</para>
 *
 * Since: 0.3.5
 */
/**
 * folks_name_details_get_full_name:
 * @self: the <link linkend="FolksNameDetails"><type>FolksNameDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksNameDetails--full-name"><type>"full-name"</type></link> property.
 * 
 * The full name of the contact.
 * 
 * <para>The full name is the name of the contact written in the way the contact prefers. For instance for English names this is usually the given name followed by the family name, but Chinese names are usually the family name followed by the given name. The full name could or could not contain additional names (like a middle name), prefixes or suffixes.</para><para>The full name must not be <code>null</code>: the empty string represents an unset full name.</para>
 * 
 * Returns: the value of the <link linkend="FolksNameDetails--full-name"><type>"full-name"</type></link> property
 *
 * Since: 0.3.5
 */
/**
 * folks_name_details_set_full_name:
 * @self: the <link linkend="FolksNameDetails"><type>FolksNameDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksNameDetails--full-name"><type>"full-name"</type></link> property
 * 
 * Set the value of the <link linkend="FolksNameDetails--full-name"><type>"full-name"</type></link> property to @value.
 * 
 * The full name of the contact.
 * 
 * <para>The full name is the name of the contact written in the way the contact prefers. For instance for English names this is usually the given name followed by the family name, but Chinese names are usually the family name followed by the given name. The full name could or could not contain additional names (like a middle name), prefixes or suffixes.</para><para>The full name must not be <code>null</code>: the empty string represents an unset full name.</para>
 *
 * Since: 0.3.5
 */
/**
 * FolksNameDetails:nickname:
 * 
 * The nickname of the contact.
 * 
 * <para>The nickname is the name that the contact chose for himself. This is different from <link linkend="FolksAliasDetails--alias"><type>"alias"</type></link> as aliases can be chosen by the user and not by the contacts themselves.</para><para>Consequently, setting the nickname only makes sense in the context of an address book when updating the information a contact has specified about themselves.</para><para>The nickname must not be <code>null</code>: the empty string represents an unset nickname.</para>
 *
 * Since: 0.3.5
 */
/**
 * folks_name_details_get_nickname:
 * @self: the <link linkend="FolksNameDetails"><type>FolksNameDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksNameDetails--nickname"><type>"nickname"</type></link> property.
 * 
 * The nickname of the contact.
 * 
 * <para>The nickname is the name that the contact chose for himself. This is different from <link linkend="FolksAliasDetails--alias"><type>"alias"</type></link> as aliases can be chosen by the user and not by the contacts themselves.</para><para>Consequently, setting the nickname only makes sense in the context of an address book when updating the information a contact has specified about themselves.</para><para>The nickname must not be <code>null</code>: the empty string represents an unset nickname.</para>
 * 
 * Returns: the value of the <link linkend="FolksNameDetails--nickname"><type>"nickname"</type></link> property
 *
 * Since: 0.3.5
 */
/**
 * folks_name_details_set_nickname:
 * @self: the <link linkend="FolksNameDetails"><type>FolksNameDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksNameDetails--nickname"><type>"nickname"</type></link> property
 * 
 * Set the value of the <link linkend="FolksNameDetails--nickname"><type>"nickname"</type></link> property to @value.
 * 
 * The nickname of the contact.
 * 
 * <para>The nickname is the name that the contact chose for himself. This is different from <link linkend="FolksAliasDetails--alias"><type>"alias"</type></link> as aliases can be chosen by the user and not by the contacts themselves.</para><para>Consequently, setting the nickname only makes sense in the context of an address book when updating the information a contact has specified about themselves.</para><para>The nickname must not be <code>null</code>: the empty string represents an unset nickname.</para>
 *
 * Since: 0.3.5
 */
/**
 * FolksNameDetails:
 * 
 * Interface for classes which represent contacts with names, such as <link linkend="FolksPersona"><type>FolksPersona</type></link> and <link linkend="FolksIndividual"><type>FolksIndividual</type></link>.
 *
 * Since: 0.3.5
 */
/**
 * FolksNameDetailsIface:
 * @change_structured_name: virtual method called by <link linkend="folks-name-details-change-structured-name"><function>folks_name_details_change_structured_name()</function></link>
 * @change_structured_name_finish: asynchronous finish function for <structfield>change_structured_name</structfield>, called by <link linkend="folks-name-details-change-structured-name"><function>folks_name_details_change_structured_name()</function></link>
 * @change_full_name: virtual method called by <link linkend="folks-name-details-change-full-name"><function>folks_name_details_change_full_name()</function></link>
 * @change_full_name_finish: asynchronous finish function for <structfield>change_full_name</structfield>, called by <link linkend="folks-name-details-change-full-name"><function>folks_name_details_change_full_name()</function></link>
 * @change_nickname: virtual method called by <link linkend="folks-name-details-change-nickname"><function>folks_name_details_change_nickname()</function></link>
 * @change_nickname_finish: asynchronous finish function for <structfield>change_nickname</structfield>, called by <link linkend="folks-name-details-change-nickname"><function>folks_name_details_change_nickname()</function></link>
 * @get_structured_name: getter method for the abstract property <link linkend="FolksNameDetails--structured-name"><type>"structured-name"</type></link>
 * @set_structured_name: setter method for the abstract property <link linkend="FolksNameDetails--structured-name"><type>"structured-name"</type></link>
 * @get_full_name: getter method for the abstract property <link linkend="FolksNameDetails--full-name"><type>"full-name"</type></link>
 * @set_full_name: setter method for the abstract property <link linkend="FolksNameDetails--full-name"><type>"full-name"</type></link>
 * @get_nickname: getter method for the abstract property <link linkend="FolksNameDetails--nickname"><type>"nickname"</type></link>
 * @set_nickname: setter method for the abstract property <link linkend="FolksNameDetails--nickname"><type>"nickname"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksNameDetails"><type>FolksNameDetails</type></link> implementations.
 */
