/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.util.StringTokenizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileError;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileLogBase;
import org.jkiss.dbeaver.model.exec.compile.DBCSourceHost;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ObjectCompilerLogViewer
extends DBCCompileLogBase {
    private Table infoTable;

    public ObjectCompilerLogViewer(Composite parent, final DBCSourceHost sourceHost, boolean bordered) {
        this.infoTable = new Table(parent, 0x10302 | (bordered ? 2048 : 0));
        this.infoTable.setHeaderVisible(true);
        this.infoTable.setLayoutData((Object)new GridData(1808));
        UIUtils.createTableColumn((Table)this.infoTable, (int)16384, (String)"Message");
        UIUtils.createTableColumn((Table)this.infoTable, (int)16384, (String)"Line");
        UIUtils.createTableColumn((Table)this.infoTable, (int)16384, (String)"Pos");
        if (sourceHost != null) {
            this.infoTable.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ ObjectCompilerLogViewer this$0;
                {
                    this.this$0 = this$0;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    TableItem item;
                    Object data;
                    TableItem[] selection = this.this$0.infoTable.getSelection();
                    if (selection.length > 0 && (data = (item = selection[0]).getData()) instanceof DBCCompileError) {
                        int line = ((DBCCompileError)data).getLine();
                        int position = ((DBCCompileError)data).getPosition();
                        sourceHost.positionSource(line, position);
                        sourceHost.setCompileInfo(((DBCCompileError)data).getMessage(), true);
                    }
                }
            });
        }
        this.createContextMenu();
    }

    public void clearLog() {
        super.clearLog();
        this.infoTable.removeAll();
    }

    public void layoutLog() {
        UIUtils.asyncExec(() -> {
            if (!this.infoTable.isDisposed()) {
                this.infoTable.getColumn(0).setWidth(this.infoTable.getBounds().width - 110);
                this.infoTable.getColumn(1).setWidth(50);
                this.infoTable.getColumn(2).setWidth(50);
            }
        });
    }

    protected void log(int type, Object message, Throwable t) {
        super.log(type, message, t);
        UIUtils.syncExec(() -> {
            String messageStr;
            if (this.infoTable == null || this.infoTable.isDisposed()) {
                return;
            }
            int color = -1;
            switch (type) {
                case 1: {
                    color = 10;
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    color = 8;
                    break;
                }
                case 5: 
                case 6: {
                    color = 4;
                    break;
                }
            }
            DBCCompileError error = null;
            if (message instanceof DBCCompileError) {
                error = (DBCCompileError)message;
                messageStr = error.getMessage();
            } else {
                messageStr = CommonUtils.toString((Object)message);
            }
            StringTokenizer st = new StringTokenizer(messageStr, "\n");
            while (st.hasMoreTokens()) {
                TableItem item = new TableItem(this.infoTable, 0);
                item.setText(0, st.nextToken());
                if (error != null && error.getLine() > 0) {
                    item.setText(1, String.valueOf(((DBCCompileError)message).getLine()));
                    item.setText(2, String.valueOf(((DBCCompileError)message).getPosition()));
                }
                if (color != -1) {
                    item.setForeground(this.infoTable.getDisplay().getSystemColor(color));
                }
                item.setData(message);
                this.infoTable.showItem(item);
            }
            if (t != null) {
                String prevMessage = null;
                Throwable ex = t;
                while (error != null) {
                    String errorMessage = ex.getMessage();
                    if (errorMessage != null && !errorMessage.equals(prevMessage)) {
                        prevMessage = errorMessage;
                        TableItem stackItem = new TableItem(this.infoTable, 0);
                        stackItem.setText(errorMessage);
                        stackItem.setForeground(this.infoTable.getDisplay().getSystemColor(3));
                        this.infoTable.showItem(stackItem);
                    }
                    ex = ex.getCause();
                }
            }
        });
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.infoTable);
        menuMgr.addMenuListener(manager -> {
            Action copyAction = new Action(WorkbenchMessages.Workbench_copy){

                public void run() {
                    ObjectCompilerLogViewer.this.copySelectionToClipboard();
                }
            };
            copyAction.setEnabled(this.infoTable.getSelectionCount() > 0);
            copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
            Action selectAllAction = new Action(WorkbenchMessages.Workbench_selectAll){

                public void run() {
                    ObjectCompilerLogViewer.this.infoTable.selectAll();
                }
            };
            selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
            Action clearLogAction = new Action(WorkbenchMessages.Workbench_revert){

                public void run() {
                    ObjectCompilerLogViewer.this.infoTable.removeAll();
                }
            };
            manager.add((IAction)copyAction);
            manager.add((IAction)selectAllAction);
            manager.add((IAction)clearLogAction);
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.infoTable.setMenu(menu);
        this.infoTable.addDisposeListener(e -> menuMgr.dispose());
    }

    private void copySelectionToClipboard() {
        Object[] selection = this.infoTable.getSelection();
        if (ArrayUtils.isEmpty((Object[])selection)) {
            return;
        }
        StringBuilder tdt = new StringBuilder();
        for (Object item : selection) {
            tdt.append(item.getText()).append(GeneralUtils.getDefaultLineSeparator());
        }
        UIUtils.setClipboardContents((Display)this.infoTable.getDisplay(), (Transfer)TextTransfer.getInstance(), (Object)tdt.toString());
    }
}

