/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.ProgressMonitorWithExceptionContext;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class WebUtils {
    private static final Log log = Log.getLog(WebUtils.class);
    private static final int MAX_RETRY_COUNT = 10;

    @NotNull
    public static URLConnection openConnection(String urlString, String referrer) throws IOException {
        return WebUtils.openConnection(urlString, null, referrer);
    }

    @NotNull
    public static URLConnection openConnection(String urlString, DBPAuthInfo authInfo, String referrer) throws IOException {
        return WebUtils.openURLConnection(urlString, authInfo, referrer, 1);
    }

    @NotNull
    public static URLConnection openConnection(DBRProgressMonitor monitor, String urlString, DBPAuthInfo authInfo, String referrer) throws IOException {
        return WebUtils.openURLConnection(monitor, urlString, authInfo, referrer, "GET", 1, 10000, null);
    }

    @NotNull
    private static URLConnection openURLConnection(String urlString, DBPAuthInfo authInfo, String referrer, int retryNumber) throws IOException {
        return WebUtils.openURLConnection(urlString, authInfo, referrer, "GET", retryNumber, 10000, null);
    }

    public static URLConnection openURLConnection(String urlString, DBPAuthInfo authInfo, String referrer, String method, int retryNumber, int timeout, Map<String, String> headers) throws IOException {
        return WebUtils.openURLConnection(null, urlString, authInfo, referrer, method, retryNumber, timeout, headers);
    }

    public static URLConnection openURLConnection(@Nullable DBRProgressMonitor monitor, String urlString, DBPAuthInfo authInfo, String referrer, String method, int retryNumber, int timeout, Map<String, String> headers) throws IOException {
        Object httpConnection;
        if (retryNumber > 10) {
            String message = String.format("Too many redirects (%d times to %s)", retryNumber, urlString);
            IOException ioException = new IOException(message);
            if (monitor instanceof ProgressMonitorWithExceptionContext) {
                ProgressMonitorWithExceptionContext monitorWithExceptionContext = (ProgressMonitorWithExceptionContext)monitor;
                monitorWithExceptionContext.addException(ioException);
            }
            throw ioException;
        }
        if (retryNumber > 1) {
            log.debug("Retry number " + retryNumber);
        }
        log.debug("Open [" + urlString + "]");
        DBPPreferenceStore prefs = DBWorkbench.getPlatform().getPreferenceStore();
        String proxyHost = prefs.getString("ui.proxy.host");
        Proxy proxy = null;
        if (!CommonUtils.isEmpty((String)proxyHost)) {
            int proxyPort = prefs.getInt("ui.proxy.port");
            if (proxyPort <= 0) {
                log.warn("Invalid proxy port: " + proxyPort);
            }
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
        }
        URL url = new URL(urlString);
        URLConnection connection = proxy == null ? url.openConnection() : url.openConnection(proxy);
        connection.setReadTimeout(timeout);
        connection.setConnectTimeout(timeout);
        if (connection instanceof HttpURLConnection) {
            httpConnection = (HttpURLConnection)connection;
            ((HttpURLConnection)httpConnection).setRequestMethod(method);
            ((HttpURLConnection)httpConnection).setInstanceFollowRedirects(true);
            HttpURLConnection.setFollowRedirects(true);
            connection.setRequestProperty("User-Agent", GeneralUtils.getProductTitle());
            if (referrer != null) {
                connection.setRequestProperty("X-Referrer", referrer);
            }
            if (authInfo != null && !CommonUtils.isEmpty((String)authInfo.getUserName())) {
                String encoded = Base64.getEncoder().encodeToString((authInfo.getUserName() + ":" + CommonUtils.notEmpty((String)authInfo.getUserPassword())).getBytes(GeneralUtils.UTF8_CHARSET));
                connection.setRequestProperty("Authorization", "Basic " + encoded);
            }
        }
        if (headers != null) {
            httpConnection = headers.entrySet().iterator();
            while (httpConnection.hasNext()) {
                Map.Entry me = (Map.Entry)httpConnection.next();
                connection.setRequestProperty((String)me.getKey(), (String)me.getValue());
            }
        }
        if ("POST".equals(method)) {
            connection.setDoOutput(true);
        } else {
            try {
                int responseCode;
                connection.connect();
                if (connection instanceof HttpURLConnection && (responseCode = ((HttpURLConnection)(httpConnection = (HttpURLConnection)connection)).getResponseCode()) != 200) {
                    if (responseCode == 302 || responseCode == 301 || responseCode == 303) {
                        String newUrl = connection.getHeaderField("Location");
                        return WebUtils.openURLConnection(newUrl, authInfo, referrer, retryNumber + 1);
                    }
                    throw new IOException("Can't open '" + String.valueOf(connection.getURL()) + "': " + ((HttpURLConnection)httpConnection).getResponseMessage());
                }
            }
            catch (Exception e) {
                String message = String.format("Exception during a connection to %s", connection.getURL().toString());
                log.debug(message, e);
                IOException ioException = new IOException(message, e);
                if (monitor instanceof ProgressMonitorWithExceptionContext) {
                    ProgressMonitorWithExceptionContext monitorWithExceptionContext = (ProgressMonitorWithExceptionContext)monitor;
                    monitorWithExceptionContext.addException(ioException);
                }
                throw ioException;
            }
        }
        return connection;
    }

    public static long downloadRemoteFile(@NotNull DBRProgressMonitor monitor, String taskName, String externalURL, Path localFile, DBPAuthInfo authInfo) throws IOException, InterruptedException {
        monitor.subTask("Download file '" + externalURL + "'");
        try (OutputStream outputStream = Files.newOutputStream(localFile, new OpenOption[0]);){
            long l = WebUtils.downloadRemoteFile(monitor, taskName, externalURL, outputStream, authInfo);
            return l;
        }
    }

    public static long downloadRemoteFile(@NotNull DBRProgressMonitor monitor, String taskName, String externalURL, OutputStream outputStream, DBPAuthInfo authInfo) throws IOException, InterruptedException {
        URLConnection connection = WebUtils.openConnection(externalURL, authInfo, null);
        int contentLength = connection.getContentLength();
        byte[] buffer = new byte[32768];
        ByteNumberFormat numberFormat = new ByteNumberFormat(ByteNumberFormat.BinaryPrefix.ISO);
        monitor.beginTask(taskName + " - " + externalURL, contentLength);
        try (InputStream inputStream = connection.getInputStream();){
            long startTime = System.currentTimeMillis();
            long updateTime = 0L;
            long totalRead = 0L;
            while (true) {
                int count;
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                long currentTime = System.currentTimeMillis();
                if (currentTime - updateTime > 1000L) {
                    if (contentLength >= 0) {
                        long elapsedTime = currentTime - startTime;
                        long totalDownloadTime = (long)((double)(elapsedTime * (long)contentLength) / (double)totalRead);
                        long remainingDownloadTime = totalDownloadTime - elapsedTime;
                        updateTime = currentTime;
                        monitor.subTask(NLS.bind((String)ModelMessages.dialog_web_download_text_known, (Object[])new Object[]{numberFormat.format(totalRead), numberFormat.format(contentLength), String.format("%.2f%%", (double)totalRead / (double)contentLength * 100.0), remainingDownloadTime > 0L ? RuntimeUtils.formatExecutionTime(remainingDownloadTime) : "-"}));
                    } else {
                        monitor.subTask(NLS.bind((String)ModelMessages.dialog_web_download_text_unknown, (Object)numberFormat.format(totalRead)));
                    }
                }
                if ((count = inputStream.read(buffer)) <= 0) {
                    long l = totalRead;
                    return l;
                }
                outputStream.write(buffer, 0, count);
                monitor.worked(count);
                totalRead += (long)count;
            }
        }
        finally {
            monitor.done();
        }
    }
}

