/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSequence;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class OracleSequenceManager
extends SQLObjectEditor<OracleSequence, OracleSchema> {
    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 4L;
    }

    protected void validateObjectProperties(DBRProgressMonitor monitor, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)((OracleSequence)command.getObject()).getName())) {
            throw new DBException("Sequence name cannot be empty");
        }
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleSequence> getObjectsCache(OracleSequence object) {
        return object.getSchema().sequenceCache;
    }

    protected OracleSequence createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        OracleSchema schema = (OracleSchema)container;
        return new OracleSequence(schema, "NEW_SEQUENCE");
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        String sql = ((OracleSequence)command.getObject()).buildStatement(false);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Sequence", sql));
        String comment = this.buildComment((OracleSequence)command.getObject());
        if (comment != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment on Sequence", comment));
        }
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        String sql = ((OracleSequence)command.getObject()).buildStatement(true);
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter Sequence", sql));
        String comment = this.buildComment((OracleSequence)command.getObject());
        if (comment != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Comment on Sequence", comment));
        }
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        String sql = "DROP SEQUENCE " + ((OracleSequence)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL);
        SQLDatabasePersistAction action = new SQLDatabasePersistAction("Drop Sequence", sql);
        actions.add((DBEPersistAction)action);
    }

    private String buildComment(OracleSequence sequence) {
        if (!CommonUtils.isEmpty((String)sequence.getDescription())) {
            return "COMMENT ON SEQUENCE " + sequence.getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)sequence, (String)sequence.getDescription());
        }
        return null;
    }
}

