/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.undo.snapshot.IResourceSnapshot;
import org.eclipse.core.resources.undo.snapshot.ResourceSnapshotFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.ide.undo.AbstractCopyOrMoveResourcesOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class CopyProjectOperation
extends AbstractCopyOrMoveResourcesOperation {
    private URI projectLocation;
    private final IProject originalProject;
    private IResourceSnapshot<? extends IResource> originalProjectDescription;

    public CopyProjectOperation(IProject project, String name, URI location, String label) {
        super(new IResource[]{project}, IPath.fromOSString((String)name), label);
        Assert.isLegal((project != null ? 1 : 0) != 0);
        this.originalProject = project;
        this.projectLocation = location != null && URIUtil.toPath((URI)location).equals((Object)Platform.getLocation()) ? null : location;
    }

    private IProject getProposedProjectHandle() {
        if (this.destination.segmentCount() == 1) {
            return this.getWorkspace().getRoot().getProject(this.destination.lastSegment());
        }
        return null;
    }

    @Override
    protected IStatus computeMoveOrCopyStatus() {
        IStatus status = Status.OK_STATUS;
        IProject project = this.getProposedProjectHandle();
        if (project == null) {
            return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_NotEnoughInfo);
        }
        if (this.projectLocation != null) {
            status = this.getWorkspace().validateProjectLocationURI(project, this.projectLocation);
        }
        if (status.isOK()) {
            return super.computeMoveOrCopyStatus();
        }
        return status;
    }

    @Override
    protected void doExecute(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        IProject newProject = this.copyProject(this.originalProject, this.destination, this.projectLocation, monitor);
        this.setTargetResources(new IResource[]{newProject});
        this.setResourceDescriptions(new IResourceSnapshot[0]);
    }

    @Override
    protected void doUndo(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        WorkspaceUndoUtil.delete(this.resources, (IProgressMonitor)subMonitor.split(1), uiInfo, true);
        this.setTargetResources(new IResource[]{this.originalProject});
        this.setResourceDescriptions(new IResourceSnapshot[0]);
    }

    @Override
    protected boolean isDestinationPathValid(IResource resource, int index) {
        return true;
    }

    @Override
    protected String getProposedName(IResource resource, int index) {
        return this.destination.lastSegment();
    }

    @Override
    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory factory, int operation) {
        boolean update = false;
        if (operation == UNDO) {
            IResource[] iResourceArray = this.resources;
            int n = this.resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                update = true;
                factory.delete(resource);
                ++n2;
            }
        } else {
            factory.copy((IResource)this.originalProject, this.getDestinationPath((IResource)this.originalProject, 0));
        }
        return update;
    }

    @Override
    public IStatus computeUndoableStatus(IProgressMonitor monitor) {
        IStatus status = super.computeUndoableStatus(monitor);
        if (!status.isOK()) {
            return status;
        }
        if (this.originalProject == null || !this.originalProjectDescription.verifyExistence(true)) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.CopyResourcesOperation_NotAllowedDueToDataLoss);
        }
        if (status.isOK()) {
            status = this.computeDeleteStatus();
        }
        return status;
    }

    IProject copyProject(IProject project, IPath destinationPath, URI locationURI, IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName(UndoMessages.AbstractCopyOrMoveResourcesOperation_copyProjectProgress);
        boolean open = project.isOpen();
        if (!open) {
            project.open(null);
        }
        this.originalProjectDescription = ResourceSnapshotFactory.fromResource((IResource)project);
        IProjectDescription description = project.getDescription();
        description.setName(destinationPath.lastSegment());
        description.setLocationURI(locationURI);
        project.copy(description, 33, monitor);
        if (!open) {
            project.close(null);
        }
        return (IProject)this.getWorkspace().getRoot().findMember(destinationPath);
    }
}

