/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.common.AssignmentFieldLists;
import net.sf.mpxj.common.Pair;
import net.sf.mpxj.common.ResourceFieldLists;
import net.sf.mpxj.common.TaskFieldLists;
import net.sf.mpxj.mpp.CustomFieldValueItem;

public class CustomFieldContainer
implements Iterable<CustomField> {
    private final ProjectFile m_parent;
    private final Map<FieldType, CustomField> m_configMap = new HashMap<FieldType, CustomField>();
    private final Map<Integer, CustomFieldValueItem> m_valueMap = new HashMap<Integer, CustomFieldValueItem>();
    private final Map<UUID, CustomFieldValueItem> m_guidMap = new HashMap<UUID, CustomFieldValueItem>();
    private final Map<Pair<FieldTypeClass, String>, FieldType> m_aliasMap = new HashMap<Pair<FieldTypeClass, String>, FieldType>();

    public CustomFieldContainer(ProjectFile parent) {
        this.m_parent = parent;
    }

    @Deprecated
    public CustomField getCustomField(FieldType field) {
        return this.getOrCreate(field);
    }

    public CustomField get(FieldType field) {
        return this.m_configMap.get(field);
    }

    public CustomField getOrCreate(FieldType field) {
        return this.m_configMap.computeIfAbsent(field, k -> new CustomField(field, this));
    }

    public CustomField add(FieldType field) {
        CustomField result = new CustomField(field, this);
        this.m_configMap.put(field, result);
        return result;
    }

    @Deprecated
    public FieldType getFieldByAlias(FieldTypeClass typeClass, String alias) {
        return this.getFieldTypeByAlias(typeClass, alias);
    }

    public FieldType getFieldTypeByAlias(FieldTypeClass typeClass, String alias) {
        return this.m_aliasMap.get(new Pair<FieldTypeClass, String>(typeClass, alias));
    }

    public List<CustomField> getCustomFieldsByFieldTypeClass(FieldTypeClass typeClass) {
        return this.stream().filter(f -> f.getFieldType().getFieldTypeClass() == typeClass).collect(Collectors.toList());
    }

    public int size() {
        return this.m_configMap.values().size();
    }

    @Override
    public Iterator<CustomField> iterator() {
        return this.m_configMap.values().iterator();
    }

    public CustomFieldValueItem getCustomFieldValueItemByUniqueID(int uniqueID) {
        return this.m_valueMap.get(uniqueID);
    }

    public CustomFieldValueItem getCustomFieldValueItemByGuid(UUID guid) {
        return this.m_guidMap.get(guid);
    }

    public void registerValue(CustomFieldValueItem item) {
        this.m_valueMap.put(item.getUniqueID(), item);
        if (item.getGUID() != null) {
            this.m_guidMap.put(item.getGUID(), item);
        }
    }

    public void deregisterValue(CustomFieldValueItem item) {
        this.m_valueMap.remove(item.getUniqueID());
        if (item.getGUID() != null) {
            this.m_guidMap.remove(item.getGUID());
        }
    }

    void registerAlias(FieldType type, String alias) {
        this.m_aliasMap.put(new Pair<FieldTypeClass, String>(type.getFieldTypeClass(), alias), type);
    }

    public Stream<CustomField> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Set<FieldType> getConfiguredAndPopulatedCustomFieldTypes() {
        Set<FieldType> result = this.stream().map(CustomField::getFieldType).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<TaskField> populatedTaskFields = this.m_parent.getTasks().getPopulatedFields();
        populatedTaskFields.retainAll(TaskFieldLists.EXTENDED_FIELDS);
        result.addAll(populatedTaskFields);
        Set<ResourceField> populatedResourceFields = this.m_parent.getResources().getPopulatedFields();
        populatedResourceFields.retainAll(ResourceFieldLists.EXTENDED_FIELDS);
        result.addAll(populatedResourceFields);
        Set<AssignmentField> populatedAssignmentFields = this.m_parent.getResourceAssignments().getPopulatedFields();
        populatedAssignmentFields.retainAll(AssignmentFieldLists.EXTENDED_FIELDS);
        result.addAll(populatedAssignmentFields);
        return result;
    }
}

