"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class GetProxyError extends Error {
    constructor(proxy, message) {
        super(message);
        this.proxy = proxy;
    }
}
exports.GetProxyError = GetProxyError;
class ProxyAuthenticationRequiredError extends GetProxyError {
    constructor(proxy) {
        super(proxy, `Proxy require "${proxy}" authentication but no handle was provided.`);
    }
}
exports.ProxyAuthenticationRequiredError = ProxyAuthenticationRequiredError;
class ProxyInvalidCredentialsError extends GetProxyError {
    constructor(proxy) {
        super(proxy, `Proxy "${proxy}" was unable to connect due to invalid credentials`);
    }
}
exports.ProxyInvalidCredentialsError = ProxyInvalidCredentialsError;
/**
 * Error when the connection to the proxy failed ERRCONNREFUSED
 * Proxy might be down
 */
class ProxyConnectionRefusedError extends GetProxyError {
    constructor(proxy) {
        super(proxy, `Proxy "${proxy}" doesn't seem to be available. Connection refused.`);
    }
}
exports.ProxyConnectionRefusedError = ProxyConnectionRefusedError;
//# sourceMappingURL=proxy-errors.js.map