"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MenuItems = exports.menuItemsStyle = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const mediaQueries_1 = require("../../mediaQueries");
const util_1 = require("../../util");
const menuItemsStyle = (theme, props) => ({
    alignSelf: 'center',
    display: 'flex',
    justifySelf: 'end',
    [mediaQueries_1.media[mediaQueries_1.QueryKeys.TABLET_DOWN]]: {
        backgroundColor: theme.general.backgroundColor,
        bottom: 0,
        left: 0,
        overflowY: 'auto',
        position: 'fixed',
        right: 0,
        top: 0,
        transform: props.open ? 'translateX(0)' : 'translateX(110%)',
        transition: 'transform 0.25s ease',
        zIndex: 1,
    },
});
exports.menuItemsStyle = menuItemsStyle;
const filterMenuItemProps = (props) => (0, util_1.filterProps)(props, ['open']);
const MenuItems = (props) => ((0, jsx_runtime_1.jsx)("div", Object.assign({ css: (theme) => (0, exports.menuItemsStyle)(theme, props) }, filterMenuItemProps(props))));
exports.MenuItems = MenuItems;
