"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeShortcuts = exports.createShortcuts = void 0;
const electron_1 = require("electron");
const fs_extra_1 = __importDefault(require("fs-extra"));
const path_1 = __importDefault(require("path"));
const config_1 = require("../settings/config");
const linkName = `${config_1.config.name}.lnk`;
const shortcutsMap = {
    desktop: path_1.default.join(electron_1.app.getPath('desktop'), linkName),
    quickLaunch: process.env.APPDATA
        ? path_1.default.resolve(process.env.APPDATA, 'Microsoft/Internet Explorer/Quick Launch/User Pinned/TaskBar', linkName)
        : undefined,
    start: path_1.default.join(electron_1.app.getPath('appData'), 'Microsoft/Windows/Start Menu/Programs', linkName),
};
const shortcuts = Object.values(shortcutsMap).filter((path) => !!path);
function createShortcuts(exePath) {
    shortcuts.forEach(location => {
        electron_1.shell.writeShortcutLink(location, {
            appUserModelId: config_1.config.appUserModelId,
            target: exePath,
        });
    });
}
exports.createShortcuts = createShortcuts;
function removeShortcuts() {
    return __awaiter(this, void 0, void 0, function* () {
        return Promise.all(shortcuts.map(shortcut => fs_extra_1.default.remove(shortcut)));
    });
}
exports.removeShortcuts = removeShortcuts;
//# sourceMappingURL=shortcuts.js.map