"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.suggestFileName = exports.downloadFile = exports.downloadImage = exports.downloadLogs = void 0;
const electron_1 = require("electron");
const fs = __importStar(require("fs-extra"));
const image_type_1 = __importDefault(require("image-type"));
const path = __importStar(require("path"));
const commons_1 = require("@wireapp/commons");
const getLogger_1 = require("../logging/getLogger");
const logger = (0, getLogger_1.getLogger)(path.basename(__filename));
const downloadLogs = (bytes, timestamp = new Date()) => __awaiter(void 0, void 0, void 0, function* () {
    const options = {
        filters: [{ extensions: ['zip'], name: 'Archives (*.zip)' }],
    };
    const { date: formattedDate, time: formattedTime } = commons_1.DateUtil.isoFormat(timestamp);
    const formattedTimeShort = formattedTime.replace(/:/g, '-').substr(0, 5);
    const filename = `wire-logs-${formattedDate}-${formattedTimeShort}.zip`;
    return (0, exports.downloadFile)(bytes, filename, options);
});
exports.downloadLogs = downloadLogs;
const downloadImage = (bytes, timestamp) => __awaiter(void 0, void 0, void 0, function* () {
    const type = (0, image_type_1.default)(bytes);
    const options = {};
    let filename = (0, exports.suggestFileName)(timestamp);
    if (type === null || type === void 0 ? void 0 : type.ext) {
        options.filters = [
            {
                extensions: [type.ext],
                name: 'Images',
            },
        ];
        filename += `.${type.ext}`;
    }
    return (0, exports.downloadFile)(bytes, filename, options);
});
exports.downloadImage = downloadImage;
const downloadFile = (bytes, filename, options) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const { filePath: chosenPath } = yield electron_1.dialog.showSaveDialog(Object.assign({ defaultPath: filename }, options));
        if (chosenPath) {
            yield fs.writeFile(chosenPath, bytes);
        }
    }
    catch (error) {
        logger.error(error);
    }
});
exports.downloadFile = downloadFile;
const suggestFileName = (timestamp) => {
    const imageDate = timestamp ? new Date(Number(timestamp)) : new Date();
    const { date: formattedDate, time: formattedTime } = commons_1.DateUtil.isoFormat(imageDate);
    return `Wire ${formattedDate} at ${formattedTime}`.replace(/:/g, '-');
};
exports.suggestFileName = suggestFileName;
//# sourceMappingURL=download.js.map