/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "page_colors.h"

#include <qcheckbox.h>

#include <kcolorbutton.h>

PageColors::PageColors( QWidget *parent, const char *name ) : PageColorsBase( parent, name)
{
}

PageColors::~PageColors()
{
}

void PageColors::saveConfig()
{
    ksopts->backgroundColor = backCBtn->color();
    ksopts->errorColor = errorCBtn->color();
    ksopts->infoColor = infoCBtn->color();
    ksopts->textColor = genericTextCBtn->color();
    ksopts->channelColor = chanMsgCBtn->color();

    ksopts->ownNickColor = ownNickCBtn->color();
    ksopts->nickForeground = nickFGCBtn->color();
    ksopts->nickBackground = nickBGCBtn->color();

    ksopts->ksircColors = allowKSircColorsCB->isChecked();
    ksopts->mircColors = allowMIRCColorsCB->isChecked();
}

void PageColors::readConfig( const KSOColors *opts )
{
    backCBtn->setColor( opts->backgroundColor );
    errorCBtn->setColor( opts->errorColor );
    infoCBtn->setColor( opts->infoColor );
    genericTextCBtn->setColor( opts->textColor );
    chanMsgCBtn->setColor( opts->channelColor );

    ownNickCBtn->setColor( opts->ownNickColor );
    nickFGCBtn->setColor( opts->nickForeground );
    nickBGCBtn->setColor( opts->nickBackground );
//    nickFGColorCB->setEnabled(config->readBoolEntry("usebcolour"));

    allowKSircColorsCB->setChecked( opts->ksircColors );
    allowMIRCColorsCB->setChecked( opts->mircColors );
}

void PageColors::defaultConfig()
{
    KSOColors opts;
    readConfig( &opts );
}

void PageColors::changed()
{
    emit modified();
}

#include "page_colors.moc"
