// This file is generated by kconfig_compiler from 802-1x.kcfg.
// All changes you do to this file will be lost.
#ifndef KNM_SECURITY8021XSETTING_H
#define KNM_SECURITY8021XSETTING_H

#include <QFile>
#include <kglobal.h>
#include <kdebug.h>
#include <kcoreconfigskeleton.h>
#include "setting.h"
#include "knminternals_export.h"
namespace Knm {

class KNMINTERNALS_EXPORT Security8021xSetting : public Setting
{
  public:
    class EnumPhase1peapver
    {
      public:
      enum type { automatic, zero, one, COUNT };
    };
    class EnumPhase1peaplabel
    {
      public:
      enum type { automatic, zero, one, COUNT };
    };
    class EnumPhase2auth
    {
      public:
      enum type { none, pap, mschap, mschapv2, chap, md5, gtc, otp, tls, COUNT };
    };
    class EnumPhase2autheap
    {
      public:
      enum type { none, md5, gtc, otp, mschapv2, tls, COUNT };
    };

    Security8021xSetting( );
    Security8021xSetting(Security8021xSetting *);
    ~Security8021xSetting();

    QString name() const;

    QMap<QString,QString> secretsToMap() const;
    void secretsFromMap(QMap<QString,QString> secrets);
    QStringList needSecrets() const;
    bool hasPersistentSecrets() const;

    /**
      Set EAP
    */
    void setEap( const QStringList & v )
    {
        mEap = v;
    }

    /**
      Get EAP
    */
    QStringList eap() const
    {
      return mEap;
    }

    /**
      Set Identity
    */
    void setIdentity( const QString & v )
    {
        mIdentity = v;
    }

    /**
      Get Identity
    */
    QString identity() const
    {
      return mIdentity;
    }

    /**
      Set Anonymous identity
    */
    void setAnonymousidentity( const QString & v )
    {
        mAnonymousidentity = v;
    }

    /**
      Get Anonymous identity
    */
    QString anonymousidentity() const
    {
      return mAnonymousidentity;
    }

    /**
      Set CA Cert
    */
    void setCacert( const QByteArray & v )
    {
        mCacert = v;
    }

    void setCacert( const QString & v)
    {
        mCacert = certPathAsByteArray(v);
    }

    /**
      Get CA Cert
    */
    QByteArray cacert() const
    {
      return mCacert;
    }

    QString cacertasstring()
    {
        return certPathAsString(mCacert);
    }

    /**
      Set CA Path
    */
    void setCapath( const QString & v )
    {
        mCapath = v;
    }

    /**
      Get CA Path
    */
    QString capath() const
    {
      return mCapath;
    }

    /**
      Set subject match
    */
    void setSubjectmatch( const QString & s)
    {
        mSubjectmatch = s;
    }

    /**
      Get subject match
    */
    QString subjectmatch() const
    {
        return mSubjectmatch;
    }

    /**
      set altsubject matches
    */
    void setAltsubjectmatches( const QStringList & v)
    {
        mAltsubjectmatches = v;
    }

    /**
      add altsubject match
    */
    void addAltsubjectmatch( const QString & s)
    {
        if (!mAltsubjectmatches.contains(s))
            mAltsubjectmatches.append(s);
    }

    /**
      get altsubject matches
    */
    QStringList altsubjectmatches() const
    {
        return mAltsubjectmatches;
    }

    /**
      Set Client Cert
    */
    void setClientcert( const QByteArray & v )
    {
        mClientcert = v;
    }

    void setClientcert( const QString & v )
    {
        mClientcert = certPathAsByteArray(v);
    }

    /**
      Get Client Cert
    */
    QByteArray clientcert() const
    {
      return mClientcert;
    }

    QString clientcertasstring()
    {
        return certPathAsString(mClientcert);
    }

    /**
      Set Client Cert Path
    */
    void setClientcertpath( const QString & v )
    {
        mClientcertpath = v;
    }

    /**
      Get Client Cert Path
    */
    QString clientcertpath() const
    {
      return mClientcertpath;
    }

    /**
      Set Phase 1 PEAP version
    */
    void setPhase1peapver( int v )
    {
        mPhase1peapver = v;
    }

    /**
      Get Phase 1 PEAP version
    */
    int phase1peapver() const
    {
      return mPhase1peapver;
    }

    /**
      Set Phase 1 PEAP label
    */
    void setPhase1peaplabel( const QString & v )
    {
        mPhase1peaplabel = v;
    }

    /**
      Get Phase 1 PEAP label
    */
    QString phase1peaplabel() const
    {
      return mPhase1peaplabel;
    }

    /**
      Set Phase 1 fast provisioning
    */
    void setPhase1fastprovisioning( const QString & v )
    {
        mPhase1fastprovisioning = v;
    }

    /**
      Get Phase 1 fast provisioning
    */
    QString phase1fastprovisioning() const
    {
      return mPhase1fastprovisioning;
    }

    /**
      Set Phase 2 auth
    */
    void setPhase2auth( int v )
    {
        mPhase2auth = v;
    }

    /**
      Get Phase 2 auth
    */
    int phase2auth() const
    {
      return mPhase2auth;
    }

    /**
      Set Phase 2 auth eap
    */
    void setPhase2autheap( int v )
    {
        mPhase2autheap = v;
    }

    /**
      Get Phase 2 auth eap
    */
    int phase2autheap() const
    {
      return mPhase2autheap;
    }

    /**
      Set Phase 2 CA Cert
    */
    void setPhase2cacert( const QByteArray & v )
    {
        mPhase2cacert = v;
    }

    void setPhase2cacert( const QString & v )
    {
        mPhase2cacert = certPathAsByteArray(v);
    }

    /**
      Get Phase 2 CA Cert
    */
    QByteArray phase2cacert() const
    {
      return mPhase2cacert;
    }

    QString phase2cacertasstring()
    {
        return certPathAsString(mPhase2cacert);
    }

    /**
      Set Phase 2 CA Path
    */
    void setPhase2capath( const QString & v )
    {
        mPhase2capath = v;
    }

    /**
      Get Phase 2 CA Path
    */
    QString phase2capath() const
    {
      return mPhase2capath;
    }

    /**
      Set Phase 2 subject match
    */
    void setPhase2subjectmatch( const QString & s)
    {
        mPhase2subjectmatch = s;
    }

    /**
      Get Phase 2 subject match
    */
    QString phase2subjectmatch() const
    {
        return mPhase2subjectmatch;
    }

    /**
      set Phase 2 altsubject matches
    */
    void setPhase2altsubjectmatches( const QStringList & v)
    {
        mPhase2altsubjectmatches = v;
    }

    /**
      add Phase 2 altsubject match
    */
    void addPhase2altsubjectmatch( const QString & s)
    {
        if (!mPhase2altsubjectmatches.contains(s))
            mPhase2altsubjectmatches.append(s);
    }

    /**
      get Phase 2 altsubject matches
    */
    QStringList phase2altsubjectmatches() const
    {
        return mPhase2altsubjectmatches;
    }

    /**
      Set Phase 2 client cert
    */
    void setPhase2clientcert( const QByteArray & v )
    {
        mPhase2clientcert = v;
    }

    void setPhase2clientcert( const QString & v )
    {
        mPhase2clientcert = certPathAsByteArray(v);
    }

    /**
      Get Phase 2 client cert
    */
    QByteArray phase2clientcert() const
    {
      return mPhase2clientcert;
    }

    QString phase2clientcertasstring()
    {
        return certPathAsString(mPhase2clientcert);
    }

    /**
      Set Phase 2 client cert path
    */
    void setPhase2clientcertpath( const QString & v )
    {
        mPhase2clientcertpath = v;
    }

    /**
      Get Phase 2 client cert path
    */
    QString phase2clientcertpath() const
    {
      return mPhase2clientcertpath;
    }

    /**
      Set Password
    */
    void setPassword( const QString & v )
    {
        mPassword = v;
    }

    /**
      Get Password
    */
    QString password() const
    {
      return mPassword;
    }

    /**
     * Set Password flags
     */
    void setPasswordflags( Setting::secretsTypes types )
    {
        mPasswordflags = types;
    }

    /**
     * Get Password flags
     */
    Setting::secretsTypes passwordflags() const
    {
        return mPasswordflags;
    }

    /**
      Set Private key
    */
    void setPrivatekey( const QByteArray & v )
    {
        mPrivatekey = v;
    }

    void setPrivatekey( const QString & v)
    {
        mPrivatekey = certPathAsByteArray(v);
    }

    /**
      Get Private key
    */
    QByteArray privatekey() const
    {
      return mPrivatekey;
    }

    QString privatekeyasstring()
    {
        return certPathAsString(mPrivatekey);
    }

    /**
      Set Private key Path
    */
    void setPrivatekeypath( const QString & v )
    {
        mPrivatekeypath = v;
    }

    /**
      Get Private key Path
    */
    QString privatekeypath() const
    {
      return mPrivatekeypath;
    }

    /**
      Set Private key password
    */
    void setPrivatekeypassword( const QString & v )
    {
        mPrivatekeypassword = v;
    }

    /**
      Get Private key password
    */
    QString privatekeypassword() const
    {
      return mPrivatekeypassword;
    }

    /**
     * Set Private key password flags
     */
    void setPrivatekeypasswordflags( Setting::secretsTypes types )
    {
        mPrivatekeypasswordflags = types;
    }

    /**
     * Get Private key password flags
     */
    Setting::secretsTypes privatekeypasswordflags() const
    {
        return mPrivatekeypasswordflags;
    }

    /**
      Set Phase 2 private key
    */
    void setPhase2privatekey( const QByteArray & v )
    {
        mPhase2privatekey = v;
    }

    void setPhase2privatekey( const QString & v)
    {
        mPhase2privatekey = certPathAsByteArray(v);
    }

    /**
      Get Phase 2 private key
    */
    QByteArray phase2privatekey() const
    {
      return mPhase2privatekey;
    }

    QString phase2privatekeyasstring()
    {
        return certPathAsString(mPhase2privatekey);
    }

    /**
      Set Phase 2 Private key Path
    */
    void setPhase2privatekeypath( const QString & v )
    {
        mPhase2privatekeypath = v;
        setPhase2privatekey( getBytes(v));
    }

    /**
      Get Phase 2 Private key Path
    */
    QString phase2privatekeypath() const
    {
      return mPhase2privatekeypath;
    }

    /**
      Set Phase 2 private key password
    */
    void setPhase2privatekeypassword( const QString & v )
    {
        mPhase2privatekeypassword = v;
    }

    /**
      Get Phase 2 private key password
    */
    QString phase2privatekeypassword() const
    {
      return mPhase2privatekeypassword;
    }

    /**
     * Set Phase 2 private key password flags
     */
    void setPhase2privatekeypasswordflags( Setting::secretsTypes types )
    {
        mPhase2privatekeypasswordflags = types;
    }

    /**
     * Get Phase 2 private key password flags
     */
    Setting::secretsTypes phase2privatekeypasswordflags() const
    {
        return mPhase2privatekeypasswordflags;
    }

    /**
     * Set PIN
     */
    void setPin( const QString & v )
    {
        mPin = v;
    }

    /**
     * Get PIN
     */
    QString pin() const
    {
        return mPin;
    }

    /**
     * Set PIN flags
     */
    void setPinflags( Setting::secretsTypes types )
    {
        mPinflags = types;
    }

    /**
     * Get PIN flags
     */
    Setting::secretsTypes pinflags() const
    {
        return mPinflags;
    }

    /**
      Set Use System CA Certs
    */
    void setUseSystemCaCerts( bool v )
    {
        mUseSystemCaCerts = v;
    }

    /**
      Get Use System CA Certs
    */
    bool useSystemCaCerts() const
    {
      return mUseSystemCaCerts;
    }

    /**
      Set Connection uses 802.1x
    */
    void setEnabled( bool v )
    {
        mEnabled = v;
    }

    /**
      Get Connection uses 802.1x
    */
    bool enabled() const
    {
      return mEnabled;
    }

    QByteArray certPathAsByteArray(const QString & path)
    {
        if (!path.isEmpty()) {
            QByteArray arr = QByteArray("file://" + path.toUtf8());
            arr.append('\0');
            return arr;
        }
        else {
            return QByteArray();
        }
    }

    QString certPathAsString(const QByteArray & path)
    {
        if (path.startsWith("file://"))
            return QString(path.mid(7));
        else
            return QString();
    }

    enum EapMethod
    {
        ttls = 1,
        peap = 2,
        tls  = 4,
        leap = 8
    };
    Q_DECLARE_FLAGS(EapMethods, EapMethod)

    void setEapFlags( const EapMethods& methods )
    {
        QStringList eap;
        if (methods.testFlag(ttls))
            eap.append("ttls");
        if (methods.testFlag(tls))
            eap.append("tls");
        if (methods.testFlag(peap))
            eap.append("peap");
        if (methods.testFlag(leap))
            eap.append("leap");
kDebug() << eap;
        setEap(eap);
    }

    EapMethods eapFlags() const
    {
        QStringList eaps = eap();
        EapMethods eapFlags;
        if (eaps.contains("ttls"))
            eapFlags = eapFlags | ttls;
        if (eaps.contains("tls"))
            eapFlags = eapFlags | tls;
        if (eaps.contains("peap"))
            eapFlags = eapFlags | peap;
        if (eaps.contains("leap"))
            eapFlags = eapFlags | leap;
        return eapFlags;
    }

  protected:

    // 802-1x
    QStringList mEap;
    QString mIdentity;
    QString mAnonymousidentity;
    QByteArray mCacert;
    QString mCapath;
    QString mSubjectmatch;
    QStringList mAltsubjectmatches;
    QByteArray mClientcert;
    QString mClientcertpath;
    int mPhase1peapver;
    QString mPhase1peaplabel;
    QString mPhase1fastprovisioning;
    int mPhase2auth;
    int mPhase2autheap;
    QByteArray mPhase2cacert;
    QString mPhase2capath;
    QString mPhase2subjectmatch;
    QStringList mPhase2altsubjectmatches;
    QByteArray mPhase2clientcert;
    QString mPhase2clientcertpath;
    QString mPassword;
    QByteArray mPrivatekey;
    QString mPrivatekeypath;
    QString mPrivatekeypassword;
    QByteArray mPhase2privatekey;
    QString mPhase2privatekeypath;
    QString mPhase2privatekeypassword;
    QString mPin;
    bool mEnabled;
    bool mUseSystemCaCerts;
    Setting::secretsTypes mPasswordflags;
    Setting::secretsTypes mPrivatekeypasswordflags;
    Setting::secretsTypes mPhase2privatekeypasswordflags;
    Setting::secretsTypes mPinflags;

  private:
    QByteArray getBytes(const QString & fileName);
};

Q_DECLARE_OPERATORS_FOR_FLAGS(Security8021xSetting::EapMethods)

}

#endif

