/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#include "kbabel.h"
#include "catalog.h"

#include "version.h"

#include <kapp.h>
#include <dcopclient.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kaboutdata.h>

#include <qfile.h>

static KCmdLineOptions options[] =
{
   {"+[file]",I18N_NOOP("files to open"),0},
   {0,0,0}
};


int main(int argc, char **argv)
{
    KAboutData about("kbabel",I18N_NOOP("KBabel"),VERSION,
       I18N_NOOP("A advanced po-file editor."),KAboutData::License_GPL,
       "(c) 1999-2000, Matthias Kiefer","http://i18n.kde.org/tools/kbabel",
       0,"matthias.kiefer@gmx.de");

    about.addAuthor("Matthias Kiefer",0,"matthias.kiefer@gmx.de");
    about.addCredit("Thomas Diehl",I18N_NOOP("gave many hints to the gui\n\
and the behaviour of KBabel."),"thd@kde.org");

    // Initialize command line args
    KCmdLineArgs::init(argc, argv, &about);

    // Tell which options are supported
    KCmdLineArgs::addCmdLineOptions( options );

    // Add options from other components
    KApplication::addCmdLineOptions();

    KApplication app;

    // register ourselves as a dcop client
    app.dcopClient()->registerAs(app.name());

    // see if we are starting with session management
    if (app.isRestored())
        RESTORE(KBabel)
    else
    {
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

        // no session.. just start up normally
        KBabel *widget = new KBabel;
        widget->show();
        for (int i=0; i < args->count(); i++)
        {
           widget->open( QFile::decodeName( args->arg(i) ), (bool)i );
        }


        args->clear();
    }

    return app.exec();
}
