/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */

#include <qstring.h>
#include <klocale.h>
#include <knuminput.h>

#include "gotodialog.h"

GotoDialog::GotoDialog(int max,QWidget* parent)
   : KDialogBase(parent,0,true,i18n("Goto Entry"),Ok|Cancel)
{
   QGroupBox* box=new QGroupBox(1,Qt::Horizontal,i18n("Goto Entry:"),this);
   _spinBox= new KIntSpinBox(1,max,1,1,10,box);

   setMainWidget(box);
}

GotoDialog::~GotoDialog()
{
}


int GotoDialog::number()
{
   return _spinBox->value();
}

void GotoDialog::setMax(int max)
{
   _spinBox->setRange(1,max);
   if(_spinBox->value()>max)
      _spinBox->setValue(max);
}
