/***************************************************************************
                          helpme.cpp  -  description
                             -------------------
    begin                : Tue Jul 25 2000
    begin                : Sat Dec 4 1999
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "helpme.h"
//#include <kurllabel.h>
#include <qprogressdialog.h>
#include <sys/stat.h>
#if defined(_WS_X11_)
#include <unistd.h> 
#endif
#if defined(_WS_WIN_)
#include <windows.h>
#endif
#include "helpwindow.h"

HelpMe::HelpMe(QWidget *parent,  QString name ) : QDialog(parent,name)
{
    local_library = (QDir::homeDirPath ()) +"/.gutenbrowser";
    setCaption(tr("About Gutenbrowser"));
    resize(500,350);
    setMinimumSize(500,350);
    setMaximumSize(500,350);
    
    QLabel* StatusBar;
    StatusBar = new QLabel( this, "Status_Bar" );
    StatusBar->setMinimumSize( 0, 0 );
    StatusBar->setFrameStyle( 0 );
    StatusBar->setLineWidth( 2 );
    StatusBar->setMidLineWidth( 0 );
    StatusBar->QFrame::setMargin( 0 );
//  StatusBar->setText( QString(tr("Gutenbrowser Version "))+ VERSION ); // FIXME
    StatusBar->setText( QString(tr("Gutenbrowser version  "VERSION)));
    StatusBar->setMargin( -1 );
    StatusBar->setGeometry(10,10,220,20);

    Edit = new QMultiLineEdit(this, "");
    Edit->setGeometry(10,40,480,240);
    Edit->setReadOnly(true);
    Edit->append(tr("Based on gutenbook.pl, available from http://www.gutenbook.org"));
    Edit->append(tr("Much appreciation to Lee Burgess,"));
    Edit->append(tr("for the original idea and concept of gutenbook."));
    Edit->append("");
    Edit->append(tr("A list of current Gutenberg ftp sites is at http://promo.net/pg/index.html"));
    Edit->append("");
    Edit->append(tr("For bug reports, comments or questions about Gutenbrowser, email"));
    Edit->append(tr("ljp@llornkcor.com"));
    Edit->append("");
    Edit->append(tr("Arnold's Laws of Documentation:"));
    Edit->append(tr("(1) If it should exist, it doesn't."));
    Edit->append(tr("(2) If it does exist, it's out of date."));
    Edit->append(tr("(3) Only documentation for"));
    Edit->append(tr("useless programs transcends the"));
    Edit->append(tr("first two laws."));
    Edit->append("");
    Edit->append(tr("Everything is temporary, anyway....\n :o)"));
  QString pixDir;
#if defined(_WS_X11_)
  pixDir="/usr/share/gutenbrowser";
#endif
#if defined(_WS_WIN_)
  pixDir=local_library;
#endif

    QPushButton *help;
    help = new QPushButton(this);
    help->setGeometry(360,10,60,28);
    help->setPixmap( QPixmap( pixDir+"/pix/help.xpm"));
    help->setText("Help");
    connect( help,SIGNAL(clicked()),this,SLOT( help() ));
    
    QPushButton *ok;
    ok = new QPushButton(this);
    ok->setGeometry(430,10,60,28);
    ok->setPixmap(  QPixmap( pixDir+"/pix/exit.xpm"));
    ok->setText("ok");
    connect(ok,SIGNAL(clicked()),this,SLOT(accept() ));


//    QLabel* StatusBar;
    QTlabel = new QLabel( this, "QT_Msg" );
    QTlabel->setMinimumSize( 0, 0 );
    QTlabel->setFrameStyle( 0 );
    QTlabel->setLineWidth( 2 );
    QTlabel->setMidLineWidth( 0 );
    QTlabel->QFrame::setMargin( 0 );
//  StatusBar->setText( QString(tr("Gutenbrowser Version "))+ VERSION ); // FIXME
    QTlabel->setText( QString(tr("Made using QT, a cross platform development API\nhttp://www.trolltech.com")));
    QTlabel->setMargin( -1 );
    QTlabel->setGeometry(10,300,420,50);


//    printf("Finished with Help initialization.\n");
}

HelpMe::~HelpMe()
{
//delete Edit;

}

void HelpMe::goToURL()
{
    
    url = "http://www.llornkcor.com/";
    goGetit( url);
}

void HelpMe::goToURL2()
{
    url = "http://www.gutenberg.org";
    goGetit( url);
}

void HelpMe::goToURL3()
{
    url = "http://www.gutenbook.org";
    goGetit( url);
}

void HelpMe::goGetit( QString url)
{
    HelpWindow *help = new HelpWindow( url, ".", 0, "gutenbrowser");
//    help->setCaption("Qt Example - Helpviewer");
  help->show();
}

void HelpMe::help()
{
    QString msg ;
#if defined(_WS_X11_)
    msg="/usr/share/doc/gutenbrowser/index.html";
#endif

#if defined(_WS_WIN_)
    msg=local_library+"/doc/index.html";
    if( msg.find( "//", 0, TRUE) != -1)
      msg.replace( msg.find( "//", 0, TRUE) , 2, "/"); 
    /// trolltech- why do I have todo this?
#endif
//    QString url = "file://"+msg;
//    goGetit( url);
    goGetit( msg);
}
