/***************************************************************************
 *   Copyright (C) 2011 by Francesco Nwokeka <francesco.nwokeka@gmail.com> *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA            *
 ***************************************************************************/

import Qt 4.7
import org.kde.plasma.graphicswidgets 0.1 as PlasmaWidgets

Item {
    id: mainWidget;

    width: 450;
    height: 250;

    // set popupIcon
    Component.onCompleted: {
        plasmoid.aspectRatioMode = IgnoreAspectRatio;
    }

    // Left panel
    LeftPanel {
        id: leftPanel;
        width: parent.width/2;

        anchors {
            top: parent.top;
            left: parent.left;
            bottom: parent.bottom;
            right: panelSeparator.left;
        }

        Component.onCompleted: {
            // set popupIcon with values loaded
            updatePopupIcon();
        }

        onSetGlobalStatusMessageSignal: {
            // pass current presence id and new global status message
            rightPanel.setGlobalStatusMessage(leftPanel.globalPresenceIdFromConfig, globalStatus);
        }

        onSetGlobalNickSignal: {
            rightPanel.setGlobalNick(globalNick);
        }

        onSetGlobalAvatarSignal: {
            rightPanel.setGlobalAvatar(globalAvatar);
        }

        onSetGlobalPresenceSignal: {
            // set id and remember status message as well
            rightPanel.setGlobalPresence(globalPresenceId, leftPanel.globalStatusMessageFromConfig);
            updatePopupIcon();
        }

    }

    // Separator
    PlasmaWidgets.Separator {
        id: panelSeparator;
        orientation: QtVertical;

        anchors {
            left: leftPanel.right;
            top: parent.top;
            bottom: parent.bottom;
            right: rightPanel.left;
        }

    }

    // Right panel
    RightPanel {
        id: rightPanel;
        width: parent.width/2;

        anchors {
            top: parent.top;
            left: panelSeparator.right;
            bottom: parent.bottom;
            right: parent.right;
            margins: 5;
        }
    }

    // updates popupicon to respect global status
    function updatePopupIcon()
    {
        if (leftPanel.globalPresenceTypeFromConfig == "available") {
            plasmoid.popupIcon = QIcon("user-online");
        } else {
            plasmoid.popupIcon = QIcon("user-" + leftPanel.globalPresenceTypeFromConfig);
        }
    }
}
