#!/bin/sh
#
#  $Id: lowerall.sh,v 1.3.10.1 2013/01/02 16:14:41 source Exp $
#
#  Rename all files in current directory to lowercase names
#  
#  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)
#  project.
#  
#  Copyright (C) 1998-2015 OpenLink Software
#  
#  This project is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by the
#  Free Software Foundation; only version 2 of the License, dated June 1991.
#  
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#  
#  

pattern="*[A-Z]*";
files="`echo $pattern`"

if test "$files" = "$pattern"
then
    echo "$0: No files matching to the pattern $pattern, nothing done."
else
    for file in $files
    do 
	mv $file `echo $file | tr 'A-Z' 'a-z'`
    done
fi
