//////////////////////////////////////////////////////////////////////////////
//
//    KEXIFUTILS.CPP
//
//    Copyright (C) 2002-2004 Renchi Raju <renchi at pooh.tam.uiuc.edu>
//                            Gilles CAULIER <caulier dot gilles at free.fr>
//                            Ralf Hoelzer <kde at ralfhoelzer.com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//////////////////////////////////////////////////////////////////////////////

#include <qptrlist.h>
#include <qheader.h>

#include <klocale.h>

#include "kexifentry.h"
#include "kexiflistviewitem.h"
#include "kexiflistview.h"

KExifListView::KExifListView(QWidget* parent)
    : KListView(parent)
{
    header()->hide();
    addColumn(i18n("Name"));
    addColumn(i18n("Value"));
    setSorting(-1);
    setResizeMode(QListView::AllColumns);
    setAllColumnsShowFocus(true);

    connect(this, SIGNAL(selectionChanged(QListViewItem*)),
            this, SLOT(slot_selectionChanged(QListViewItem*)));
}


KExifListView::~KExifListView()
{

}

void KExifListView::addItems(const QPtrList<KExifEntry>& entryList)
{
    QPtrListIterator<KExifEntry>
        entryIterator(entryList);

    KExifEntry *exifEntry   = 0;
    KExifListViewItem *prevItem = 0;

    while( (exifEntry = entryIterator.current()) != 0 ) {
        ++entryIterator;

        KExifListViewItem *item = 0;
        if (!prevItem)
            item = new KExifListViewItem(this, exifEntry);
        else
            item = new KExifListViewItem(this, prevItem,
                                         exifEntry);
        prevItem = item;

    }
}

void KExifListView::slot_selectionChanged(QListViewItem *item)
{
    if (!item) {
        emit signal_itemDescription(QString(""));
        return;
    }

    KExifListViewItem* viewItem =
        static_cast<KExifListViewItem *>(item);
    emit signal_itemDescription(viewItem->exifEntry()->getDescription());

}

#include "kexiflistview.moc"
