#ifndef GPHOTO_EVENTS_H
#define GPHOTO_EVENTS_H

#include <qevent.h>
#include <qstring.h>

#include "list_mt.h"
#include "camera_fileinfo.h"
#include "thumbnail_mt.h"

enum Gphoto_EventTypes {
  Gphoto_InitializeT = QCustomEvent::User,
  Gphoto_GetSubFoldersT,
  Gphoto_MakeFolderT,
  Gphoto_DeleteFolderT,
  Gphoto_GetThumbNailT,
  Gphoto_GetImagesInfoT,
  Gphoto_GetImageNamesT,
  Gphoto_DownloadImageT,
  Gphoto_DeleteImageT,
  Gphoto_OpenImageT,
  Gphoto_StatusMsgT,
  Gphoto_ProgressT,
  Gphoto_ErrorMsgT,
  Gphoto_BusyT
};


class Gphoto_Event_InitializeCamera : public QCustomEvent {

public:

  Gphoto_Event_InitializeCamera(const QString& _camModel,
				const QString& _camPort)
    : QCustomEvent(Gphoto_InitializeT),
      camModel(_camModel),
      camPort(_camPort)
  {}

  QString cameraModel() const {return camModel;}
  QString cameraPort() const {return camPort;}

private:

  QString camModel;
  QString camPort;

};

class Gphoto_Event_GetSubFolders : public QCustomEvent {

public:

  Gphoto_Event_GetSubFolders(bool _success, bool _finished,
			     const QString& _parentFolder,
			     const QStringList& _subFolderList,
			     const QStringList& _subFolderNameList)
    : QCustomEvent(Gphoto_GetSubFoldersT),
      m_success(_success),
      m_finished(_finished),
      m_parentFolder(_parentFolder),
      m_subFolderList(_subFolderList),
      m_subFolderNameList(_subFolderNameList)
  {}

  bool success() {return m_success;}
  bool finished() {return m_finished;}
  QString parentFolder() const {return m_parentFolder;}
  QStringList subFolderList() const {return m_subFolderList;}
  QStringList subFolderNameList() const {return m_subFolderNameList;}

private:

  bool m_success;
  bool m_finished;
  QString m_parentFolder;
  QStringList m_subFolderList;
  QStringList m_subFolderNameList;

};


class Gphoto_Event_GetImagesInfo : public QCustomEvent {

public:

  Gphoto_Event_GetImagesInfo(const QString& _parentFolder,
                             const List_MT<Camera_FileInfo>& _infoList)
    : QCustomEvent(Gphoto_GetImagesInfoT),
      m_parentFolder(_parentFolder),
      m_infoList(_infoList)
  {}

  QString parentFolder() const {return m_parentFolder;}
  List_MT<Camera_FileInfo> imagesInfoList() const {return m_infoList;}

private:

  QString m_parentFolder;
  List_MT<Camera_FileInfo> m_infoList;

};


class Gphoto_Event_GetImageNames : public QCustomEvent {

public:

  Gphoto_Event_GetImageNames(bool _success,
			     const QString& _parentFolder,
			     const QStringList& _imagesList,
			     const QStringList& _imagesInfoList)
    : QCustomEvent(Gphoto_GetImageNamesT),
      m_success(_success),
      m_parentFolder(_parentFolder),
      m_imagesList(_imagesList),
      m_imagesInfoList(_imagesInfoList)
  {}

  bool success() {return m_success;}
  QString parentFolder() const {return m_parentFolder;}
  QStringList imagesList() const {return m_imagesList;}
  QStringList imagesInfoList() const {return m_imagesInfoList;}

private:

  bool m_success;
  QString m_parentFolder;
  QStringList m_imagesList;
  QStringList m_imagesInfoList;

};


class Gphoto_Event_GetThumbNail : public QCustomEvent {

public:

  Gphoto_Event_GetThumbNail(const QString& _parentFolder,
		      const QString& _imageName,
		      const Thumbnail_MT& _thumb) :
    QCustomEvent(Gphoto_GetThumbNailT),
    m_parentFolder(_parentFolder),
    m_imageName(_imageName),
    m_thumbNail(_thumb)
  {}


  QString parentFolder() const {return m_parentFolder;}
  QString imageName()    const {return m_imageName;}
  void getThumbNail(QPixmap& pix) { m_thumbNail.fillPixmap(pix); }


private:

  QString m_parentFolder;
  QString m_imageName;
  Thumbnail_MT m_thumbNail;

};



class Gphoto_Event_DeleteImage : public QCustomEvent {

public:

  Gphoto_Event_DeleteImage(const QString& _parentFolder,
			   const QString& _imageName) :
    QCustomEvent(Gphoto_DeleteImageT),
    m_parentFolder(_parentFolder),
    m_imageName(_imageName)
  {}

  QString parentFolder() const {return m_parentFolder;}
  QString imageName()    const {return m_imageName;}

private:

  QString m_parentFolder;
  QString m_imageName;

};

class Gphoto_Event_OpenImage : public QCustomEvent {

public:

  Gphoto_Event_OpenImage(const QString& _parentFolder,
			   const QString& _imageName) :
    QCustomEvent(Gphoto_OpenImageT),
    m_parentFolder(_parentFolder),
    m_imageName(_imageName)
  {}

  QString parentFolder() const {return m_parentFolder;}
  QString imageName()    const {return m_imageName;}

private:

  QString m_parentFolder;
  QString m_imageName;

};



class Gphoto_Event_CameraStatusMsg : public QCustomEvent {

public:

  Gphoto_Event_CameraStatusMsg(const QString& _msg):
    QCustomEvent(Gphoto_StatusMsgT),
    m_msg(_msg)
  {}

  QString statusMsg() const { return m_msg;}

private:

  QString m_msg;

};


class Gphoto_Event_CameraProgress : public QCustomEvent {

public:

  Gphoto_Event_CameraProgress(const int& _val):
    QCustomEvent(Gphoto_ProgressT),
    m_val(_val)
  {}

  int val() const { return m_val;}

private:

  int m_val;

};

class Gphoto_Event_CameraErrorMsg : public QCustomEvent {

public:

  Gphoto_Event_CameraErrorMsg(const QString& _msg):
    QCustomEvent(Gphoto_ErrorMsgT),
    m_msg(_msg)
  {}

  QString errorMsg() const { return m_msg;}

private:

  QString m_msg;

};

class Gphoto_Event_Busy : public QCustomEvent {

public:

  Gphoto_Event_Busy(bool _busy):
    QCustomEvent(Gphoto_BusyT),
    m_busy(_busy)
  {}

  bool busy() { return m_busy;}

private:

  bool m_busy;

};

#endif
