#ifndef CAMERA_ICONVIEWITEM_H
#define CAMERA_ICONVIEWITEM_H

#include <qstring.h>
#include <qpixmap.h>
#include <qguardedptr.h>
#include <qiconview.h>
#include <qobject.h>

#include "thumbnailsize.h"
#include "camera_fileinfo.h"

class Camera_IconView;

class Camera_IconViewItem : public QIconViewItem,
                            public QObject
{


public:

    Camera_IconViewItem(Camera_IconView* parent);
    Camera_IconViewItem(Camera_IconView* parent,
                        const Camera_FileInfo& info,
                        Camera_IconView* globalIconView);
    Camera_IconViewItem(Camera_IconView* parent,
                        Camera_IconViewItem* actualItem);
    ~Camera_IconViewItem();

    Camera_FileInfo& fileInfo() const;

    bool isGlobalItem() {return m_isGlobalItem;}

    bool isThumbNailed() {return m_thumbNailed;}
    bool stateThumbNailed() {return m_stateThumbNailed;}
    void setThumbNail(const QPixmap& icon, const ThumbnailSize& thumbSize);
    void setThumbNail(const ThumbnailSize& thumbSize);
    void setPixmapForMime(const ThumbnailSize& thumbSize);


private:

    QPixmap *m_thumbNail;
    bool  m_thumbNailed;
    bool  m_stateThumbNailed;

    // Points to the correspoding item in global folder
    QGuardedPtr<Camera_IconViewItem> m_globalItem;
    // Points to the actual item
    QGuardedPtr<Camera_IconViewItem> m_actualItem;
    bool m_isGlobalItem;

    Camera_FileInfo *m_fileInfo;

    void syncItemWithGlobal();

};




#endif
