#include "camera_fileinfo_dialog.h"

#include <klocale.h>

#include <qstring.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>


Camera_FileInfo_Dialog::Camera_FileInfo_Dialog(const Camera_FileInfo& fileInfoReal,
                                               QWidget* parent,
                                               const char* name)

    : KDialogBase(Plain, QString("File Properties"),
                  Close, Close, parent, name, true, true)
{

    resize( 365, 267 );

    QFrame* mainFrame =  plainPage();

    layout = new QGridLayout(mainFrame, 1, 1, 10, 2);

    Camera_FileInfo& fileInfo = const_cast<Camera_FileInfo&> (fileInfoReal);

    //----------------------------------------------------------------------

    nameLabel = new QLabel(i18n("File Name :"), mainFrame);
    layout->addWidget(nameLabel, 0, 0);

    nameLabel_Val = new QLabel(fileInfo.getName(), mainFrame);
    layout->addWidget(nameLabel_Val, 0, 1);

    //----------------------------------------------------------------------

    folderLabel = new QLabel(i18n("Folder :"), mainFrame);
    layout->addWidget(folderLabel, 1, 0);

    folderLabel_Val = new QLabel(fileInfo.getFolder(), mainFrame);
    layout->addWidget(folderLabel_Val, 1, 1);

    //----------------------------------------------------------------------


    mimeLabel = new QLabel(i18n("MimeType :"), mainFrame);
    layout->addWidget(mimeLabel, 2, 0);

    QString mime(fileInfo.getMime());
    if (mime.isEmpty()) mime = "Unknown";

    mimeLabel_Val = new QLabel(mime, mainFrame);
    layout->addWidget(mimeLabel_Val, 2, 1);

    //----------------------------------------------------------------------

    timeLabel = new QLabel(i18n("Last Modified Time :"), mainFrame);
    layout->addWidget(timeLabel, 3, 0);

    QString time(fileInfo.getTime().stripWhiteSpace());
    if (time.isEmpty()) time = "Unknown";

    timeLabel_Val = new QLabel(time, mainFrame);
    layout->addWidget(timeLabel_Val, 3, 1);

    //----------------------------------------------------------------------


    sizeLabel = new QLabel(i18n("Size :"), mainFrame);
    layout->addWidget(sizeLabel, 4, 0);

    QString size;
    int sizeVal = fileInfo.getSize();
    if (sizeVal < 0)
        size = "Unknown";
    else {
        size.setNum(sizeVal);
        size += " Bytes";
    }

    sizeLabel_Val = new QLabel(size, mainFrame);
    layout->addWidget(sizeLabel_Val, 4, 1);

    //----------------------------------------------------------------------

    widthLabel = new QLabel(i18n("Width :"), mainFrame);
    layout->addWidget(widthLabel, 5, 0);

    QString width;
    int widthVal = fileInfo.getWidth();
    if (widthVal < 0)
        width = "Unknown";
    else
        width.setNum(widthVal);

    widthLabel_Val = new QLabel(width, mainFrame);
    layout->addWidget(widthLabel_Val, 5, 1);

    //----------------------------------------------------------------------

    heightLabel = new QLabel(i18n("Height :"), mainFrame);
    layout->addWidget(heightLabel, 6, 0);

    QString height;
    int heightVal = fileInfo.getHeight();
    if (heightVal < 0)
        height = "Unknown";
    else
        height.setNum(heightVal);

    heightLabel_Val = new QLabel(height, mainFrame);
    layout->addWidget(heightLabel_Val, 6, 1);

    //----------------------------------------------------------------------

    readPermsLabel = new QLabel(i18n("Read Permissions :"), mainFrame);
    layout->addWidget(readPermsLabel, 7, 0);

    QString readPerms;
    int readPermsVal = fileInfo.getReadPermissions();
    if (readPermsVal < 0)
        readPerms = "Unknown";
    else if (readPermsVal == 0)
        readPerms = "No";
    else
        readPerms = "Yes";

    readPermsLabel_Val = new QLabel(readPerms, mainFrame);
    layout->addWidget(readPermsLabel_Val, 7, 1);

    //----------------------------------------------------------------------

    writePermsLabel = new QLabel(i18n("Delete Permissions :"), mainFrame);
    layout->addWidget(writePermsLabel, 8, 0);

    QString writePerms;
    int writePermsVal = fileInfo.getReadPermissions();
    if (writePermsVal < 0)
        writePerms = "Unknown";
    else if (writePermsVal == 0)
        writePerms = "No";
    else
        writePerms = "Yes";

    writePermsLabel_Val = new QLabel(writePerms, mainFrame);
    layout->addWidget(writePermsLabel_Val, 8, 1);

    //----------------------------------------------------------------------

    downloadedLabel = new QLabel(i18n("Status :"), mainFrame);
    layout->addWidget(downloadedLabel, 9, 0);

    QString downloaded;
    int downloadedVal = fileInfo.getDownloaded();
    if (downloadedVal < 0)
        downloaded = "Unknown";
    else if (downloadedVal == 0)
        downloaded = "Not Downloaded";
    else
        downloaded = "Downloaded";

    downloadedLabel_Val = new QLabel(downloaded, mainFrame);
    layout->addWidget(downloadedLabel_Val, 9, 1);

    //----------------------------------------------------------------------

    connect(this, SIGNAL(closeClicked()),
            this, SLOT(slot_close()));

}

Camera_FileInfo_Dialog::~Camera_FileInfo_Dialog()
{

}

void Camera_FileInfo_Dialog::slot_close()
{
    close();
}
