#ifndef CAMERA_BROWSER_H
#define CAMERA_BROWSER_H

#include <qwidget.h>
#include <qpoint.h>

#include <kservice.h>

#include "thumbnailsize.h"

class QSplitter;
class QWidgetStack;
class QString;
class QListViewItem;
class QIconViewItem;
class QGridLayout;
class QGroupBox;
class QCheckBox;
class QLabel;
class QPushButton;
class QCustomEvent;

class KIconView;
class KListView;
class KStatusBar;
class KProgress;
class KComboBox;

class Camera_Folder;
class Gphoto_Controller;
class Camera_IconView;
class Camera_IconViewItem;





class Camera_Browser: public QWidget {

    Q_OBJECT

public:

    enum selection {
        All,
        None,
        Invert
    };

    Camera_Browser(QWidget *parent);
    ~Camera_Browser();

    void camera_new();
    void camera_connect();
    void camera_disconnect();
    void camera_cancel();
    void camera_download();
    void camera_downloadAll();
    void camera_delete();
    void camera_deleteAll();
    void camera_hideFolders();
    void camera_hideFolders(bool hide);
    void camera_hideStatusBar();
    void camera_setSelection(int);

    void setDefaultDownloadDir(const QString& downloadDir);
    void checkThumbnailsButton(bool on);
    void startWithGlobalFolder(bool val);
    void setThumbnailSize(ThumbnailSize::Size size);

    QString cameraModel() const;
    QString cameraPort() const;


private:

    void resetStatusBar();

public:

    bool m_camAbilities_Preview;
    bool m_camAbilities_Delete;
    bool m_camAbilities_Upload;
    bool m_camAbilities_MkDir;
    bool m_camAbilities_DelDir;

private:

    KListView     *m_camFolderTree;
    QWidgetStack  *m_camIconViewStack;
    KIconView     *m_camIconViewRoot;
    Camera_Folder *m_camVirtualFolder;
    int m_numIconViewStacks;

    QGridLayout *m_mainLayout;
    QSplitter   *m_splitter;
    QLabel      *m_camLabel;
    QCheckBox   *m_checkboxThumbs;

    QGroupBox   *m_GroupBox;
    QGridLayout *m_GroupBoxLayout;
    QPushButton *m_camDirButton;
    KComboBox   *m_camDirBox;

    Gphoto_Controller *m_gpController;
    QString m_camGlobFolder;
    bool m_showGlobalFolder;

    KStatusBar *m_statusBar;
    KProgress  *m_progressBar;

    ThumbnailSize m_thumbnailSize;

    KService::Ptr imageServicePtr;

    bool m_busyProcessing;
    bool m_cancelOperation;
    bool m_overwriteAll;

    int totalItemCount;
    int totalImageCount;
    int totalThumbsRequested;
    int totalThumbsDownloaded;
    int totalImagesRequested;
    int totalImagesDownloaded;


    void eventCameraInitialized(QCustomEvent *event);
    void eventSubFolders(QCustomEvent *event);
    void eventGetImagesInfo(QCustomEvent *event);
    void eventGetThumbNail(QCustomEvent *event);
    void eventDeleteImage(QCustomEvent *event);
    void eventOpenImage(QCustomEvent *event);
    void eventCameraStatusMsg(QCustomEvent *event);
    void eventCameraProgress(QCustomEvent *event);
    void eventCameraErrorMsg(QCustomEvent *event);
    void eventCameraBusy(QCustomEvent *event);

    void downloadOneImage(Camera_IconViewItem *item,
                          bool& proceedFurther);

protected:

    void customEvent(QCustomEvent *event);

signals:

    void signal_startedProcessing();
    void signal_stoppedProcessing();

    void signal_cameraConnected();

private slots:

    void slot_camFolderTreeClicked(QListViewItem *item);
    void slot_camIconViewClicked(QIconViewItem *item);
    void slot_camIconViewRightClicked(QIconViewItem*, const QPoint&);
    void slot_showThumbnails(bool checked);
    void slot_setStatusMsg(const QString& msg);
    void slot_setProgressVal(int val);
    void slot_camDirBrowse();

};



#endif
