/*  This file is part of the KDE project
    Copyright (C) 2008 Dario Freddi <drf54321@gmail.com>
    Copyright (C) 2008 Lukas Appelhans <l.appelhans@gmx.de>
    Copyright (C) 2008 Alessandro Diaferia <alediaferia@gmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/
#ifndef AUTHORIZATIONSMODEL_H
#define AUTHORIZATIONSMODEL_H

#include <QAbstractItemModel>

#include <polkit-dbus/polkit-dbus.h>

class AbstractItem;
class Group;
class Item;

namespace PolkitKde
{

class AuthorizationsModel : public QAbstractItemModel
{
    Q_OBJECT
public:
    enum DataRoles {
        IdRole = 41,
        PolkitEntryRole = 42,
        EntryTypeRole = 43
    };

    enum EntryType {
        GroupEntry = 0,
        ActionEntry = 1
    };

    AuthorizationsModel(QObject* parent = 0);
    virtual ~AuthorizationsModel();

    virtual QModelIndex index(int row, int column, const QModelIndex &parent = QModelIndex()) const;
    virtual QModelIndex parent(const QModelIndex &index) const;
    virtual int rowCount(const QModelIndex &parent = QModelIndex()) const;
    virtual int columnCount(const QModelIndex &parent = QModelIndex()) const;
    virtual QVariant data(const QModelIndex & index, int role = Qt::DisplayRole) const;
    virtual bool hasChildren(const QModelIndex &parent = QModelIndex()) const;
    PolKitPolicyFileEntry* polkitFileEntry(const QModelIndex &index);
    PolKitPolicyFileEntry* getPFEFromActionId(const QString &action_id);
    EntryType entryType(const QModelIndex &index);
    QString polkitId(const QModelIndex &index) const;
    QModelIndex indexFromId(const QString &id) const;

    void addEntries(const QList<PolKitPolicyFileEntry *> &entries);//Make it non compile? :P??lemme try first ;)ok, you're trying to compile.. :PPkKAuthorization.cpp:124: error: no matching function for call to 'PolkitKde::AuthorizationsModel::addEntry(PolKitPolicyFileEntry*&)' that'S why^^well change back if you need to compile k will do now first... we can change that later k?k
    void clear() {}
    QList<Item*> items(Group * group = 0);
    QList<Group*> groups(Group * group = 0);
    QModelIndexList itemsAsModelIndex(const QModelIndex &parent) const;

private:
    Group *rootItem;
};

}

Q_DECLARE_METATYPE(PolKitPolicyFileEntry*)

#endif
