/***************************************************************************
                          refreshdlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef REFRESHDLG_H
#define REFRESHDLG_H

#include <kdialogbase.h>

class QCheckBox;
class KplSpinBox;

/**
  * Load periodically dialog. Provides a dialog to setup periodically reloading.
  * @author Werner Stille
  */
class RefreshDlg : public KDialogBase
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent parent widget.
   * @param act true for active.
   * @param tRef refresh interval in seconds.
   */
  RefreshDlg(QWidget* parent, bool* act, int* tRef);
  /** Destructor. */
  ~RefreshDlg();

protected slots:
  /** Accepts settings and leaves the dialog. */
  virtual void slotOk();

protected:
  bool* act;
  int* tRef;
  KplSpinBox* dt;
  QCheckBox* activate;
};

#endif
