/***************************************************************************
*                        kfilednddetailview.cpp  -  description
*                           -------------------
*  begin                : Wed Nov 1 2000
*  copyright            : (C) 2000 by Bjrn Sahlstrm
*  email                : bjorn@kbear.org
***************************************************************************/

/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include "kfilednddetailview.h"
//-----------------------------------------------
KFileDnDDetailView::KFileDnDDetailView(QWidget *parent, const char *name )
	:	KFileDetailView(parent,name), myAutoOpenTimer( this ),
		autoOpenTime( 750 ), b_useAutoOpenTimer( true ), dropItem(0)
{
	setDnDEnabled( true );
	useAutoOpenTimer( true );
}
//-----------------------------------------------
KFileDnDDetailView::~KFileDnDDetailView(){
}
//-----------------------------------------------
void KFileDnDDetailView::slotOpenFolder(){
	myAutoOpenTimer.stop();
	if( !dropItem )
		return;
	const KFileViewItemList* fileList = KFileView::items();
	KFileViewItemListIterator it( *(QList<KFileViewItem>*)fileList );
	for( ; it.current() ;++it ){
		if( (*it)->name() == dropItem->text(0) && (*it)->isFile())
			return;
	}
	emit openFolder( dropItem->text(0) );
}
//-----------------------------------------------
void KFileDnDDetailView::contentsDragEnterEvent( QDragEnterEvent *e ) {
	setSelectionMode( KFile::Single );
	if ( acceptDrag( e ) ) {
		e->accept( true );
		QListViewItem *i = itemAt( contentsToViewport( e->pos() ) );
		if ( i && b_useAutoOpenTimer ) {
			dropItem = i;
			myAutoOpenTimer.start( autoOpenTime );
		}
	}
}
//-----------------------------------------------
void KFileDnDDetailView::contentsDragMoveEvent( QDragMoveEvent *e ) {
	if ( acceptDrag( e ) ) {
		e->accept( true );
		QListViewItem *i = itemAt( contentsToViewport(  e->pos() ) );
		if ( i ) {
			if ( i != dropItem && b_useAutoOpenTimer ) {
				myAutoOpenTimer.stop();
				dropItem = i;
				myAutoOpenTimer.start( autoOpenTime );
			}
		}
		else
			myAutoOpenTimer.stop();
	}
}
//-----------------------------------------------
void KFileDnDDetailView::contentsDragLeaveEvent( QDragLeaveEvent* ) {
	if( b_useAutoOpenTimer ) {
		myAutoOpenTimer.stop();
		dropItem = 0;
	}
	setSelectionMode( KFile::Extended );
}
//-----------------------------------------------
void KFileDnDDetailView::contentsDropEvent( QDropEvent* e ) {
	setSelectionMode( KFile::Extended );
	if( b_useAutoOpenTimer ) {
		myAutoOpenTimer.stop();
		dropItem = 0;
	}
	if ( acceptDrag( e ) ) {
		e->accept( true );
		QListViewItem *afterme;
		QPoint p (contentsToViewport( e->pos() ));

		// Get the position to put it in
		QListViewItem *atpos = itemAt( p );

		if ( ! atpos ) // if no item
			afterme = lastItem();
		else { // get the closest one
			// That is, the space between two listviewitems
			// Since this aims to be user-friendly :)
			int y = mapFromGlobal(p).y() - mapFromGlobal(itemRect(atpos).topLeft()).y();
			afterme = y < (atpos->height()/2) ? atpos->itemAbove() : atpos;
		}
//		QStringList urlList;    // to the outside world
//		QUriDrag::decodeToUnicodeUris( e, urlList );
		KURL::List urlList;    // to the outside world
		KURLDrag::decode( e, urlList );
		emit dropped( urlList );
		QApplication::sendPostedEvents();
	}
}
//-----------------------------------------------
void KFileDnDDetailView::startDrag(){
	// create a list of the URL:s that we want to drag
	KURL::List urls;
	const KFileViewItemList* fileList = KFileView::selectedItems();
	KFileViewItemListIterator it( *(QList<KFileViewItem>*)fileList );
	for ( ; it.current(); ++it ){
		urls.append( (*it)->url() );
	}
	myDragObject = KURLDrag::newDrag( urls, this );
	myDragObject->setPixmap( *(currentItem()->pixmap(0)) );
	myDragObject->dragCopy();   // start the drag
}
//-----------------------------------------------
QDragObject* KFileDnDDetailView::dragObject() const {
	return myDragObject;
}
//-----------------------------------------------
bool KFileDnDDetailView::acceptDrag(QDropEvent* e ) const {
	return QUriDrag::canDecode( e );
}
//-----------------------------------------------
void KFileDnDDetailView::setAutoOpenTime( const int& time ){
	autoOpenTime = time;
	useAutoOpenTimer();
}
//-----------------------------------------------
void KFileDnDDetailView::useAutoOpenTimer( bool use ){
	b_useAutoOpenTimer = use;
	if( use )
		connect( &myAutoOpenTimer, SIGNAL( timeout() ),this, SLOT( slotOpenFolder() ) );
	else {
		disconnect( &myAutoOpenTimer, SIGNAL( timeout() ),this, SLOT( slotOpenFolder() ) );
		dropItem = 0;
		myAutoOpenTimer.stop();
	}
}
//-----------------------------------------------
void KFileDnDDetailView::setDnDEnabled( bool useDnd ){
	setDragEnabled( useDnd );
	setDropVisualizer( useDnd );
	setAcceptDrops( useDnd );
	viewport()->setAcceptDrops( useDnd );
}
//-----------------------------------------------
