/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include <qlistbox.h>
#include <qvaluelist.h>
#include <qstringlist.h>
#include <kdialogbase.h>
#include <klocale.h>

#include <kbiblioshell.h>
#include <kbibliodoc.h>
#include <newentrydialog.h>


NewEntryDialog::NewEntryDialog( KBiblioShell *shell, QWidget *parent, const char *name )
  : KDialogBase ( parent, name, true, i18n( "Entry Type Dialog" ), KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, false )
{
  mSelected = "";

  mEntryTypes = shell->document()->entryTypesNames();

  mListBox = new QListBox( this );
  mListBox->insertStringList( shell->entryDescriptionList( mEntryTypes ) );
  mListBox->setCurrentItem( 0 );
  connect( mListBox, SIGNAL( doubleClicked( QListBoxItem * ) ), SLOT( slotOk() ) );
  setMainWidget( mListBox );
  resize( 300, 380 );
}

NewEntryDialog::~NewEntryDialog()
{
}

QString
NewEntryDialog::chosenType() const
{
  return mSelected;
}

void
NewEntryDialog::slotOk()
{
  mSelected = *( mEntryTypes.at( mListBox->currentItem() ) );
  accept();
}


#include "newentrydialog.moc"










