/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/


#include "entrytypes.h"

#define FIELDTYPE BibEntryFieldType::BibEntryFieldType
#define QSTRING QString::QString
#define AUTHORLIST BibEntryFieldType::AUTHORLIST
#define STRING BibEntryFieldType::STRING
#define TEXT BibEntryFieldType::TEXT

//============================================================
// allowed entry fields


const int gNoFieldTypes = 24; // the number of the following field types

const BibEntryFieldType gFieldTypes[] = {
    FIELDTYPE( STRING, "AUTHOR", "Author(s)" ),
    FIELDTYPE( STRING, "EDITOR", "Editor(s)" ),
    //  FIELDTYPE( AUTHORLIST, "AUTHOR_LIST", "Author(s)", false ),
    //FIELDTYPE( AUTHORLIST, "EDITOR_LIST", "Editor(s)", false ),
    //FIELDTYPE( AUTHORLIST, "AUTHOR_EDITOR_LIST", "Author(s)|Editor(s)", false ),
    FIELDTYPE( STRING, "ADDRESS", "Address" ),
    FIELDTYPE( STRING, "BOOKTITLE", "Book Title" ),
    FIELDTYPE( STRING, "CHAPTER", "Chapter" ),
    FIELDTYPE( STRING, "CONF_LOCATION", "Conf. Location" ),
    FIELDTYPE( STRING, "CONF_DATE", "Conf. Date" ),
    FIELDTYPE( STRING, "EDITION", "Edition" ),
    FIELDTYPE( STRING, "HOWPUBLISHED", "How Published" ),
    FIELDTYPE( STRING, "JOURNAL", "Journal" ),
    FIELDTYPE( STRING, "KEY", "Key" ),
    FIELDTYPE( STRING, "NOTE", "Note" ),
    FIELDTYPE( STRING, "NUMBER", "Number" ),
    FIELDTYPE( STRING, "MONTH", "Month" ),
    FIELDTYPE( STRING, "ORGANISATION", "Organisation" ),
    FIELDTYPE( STRING, "PAGES", "Pages" ),
    FIELDTYPE( STRING, "PUBLISHER", "Publisher" ),
    FIELDTYPE( STRING, "SERIES", "Series" ),
    FIELDTYPE( STRING, "TITLE", "Title" ),
    FIELDTYPE( STRING, "URL", "URL" ),
    FIELDTYPE( STRING, "VOLUME", "Volume" ),
    FIELDTYPE( STRING, "YEAR", "Year" ),
    FIELDTYPE( TEXT, "ABSTRACT", "Abstract" ),
    FIELDTYPE( TEXT, "ANNOTE", "Annotations" ) };


//============================================================
// allowed entry types

const QString gArticleType[] = {
    QString( "AUTHOR" ),
    QString( "TITLE" ),
    QString( "JOURNAL" ),
    QString( "MONTH" ),
    QString( "YEAR" ),
    QString( "VOLUME" ),
    QString( "NUMBER" ),
    QString( "PAGES" ),
    QString( "NOTE" ),
    QString( "URL" ),
    QString( "ABSTRACT" ),
    QString( "ANNOTE" ),
    QString( "-1" ) };

const QString gBookType[] = {
    QString( "AUTHOR" ),
    QString( "TITLE" ),
    QString( "MONTH" ),
    QString( "YEAR" ),
    QString( "VOLUME" ),
    QString( "NUMBER" ),
    QString( "SERIES" ),
    QString( "EDITION"),
    QString( "PUBLISHER" ),
    QString( "ADDRESS" ),
    QString( "NOTE" ),
    QString( "URL" ),
    QString( "ABSTRACT" ),
    QString( "ANNOTE" ),
    QString( "-1" )};

const QString gInProceedingsType[] = {
    QString( "AUTHOR" ),
    QString( "TITLE" ),
    QString( "PAGES" ),
    QString( "MONTH" ),
    QString( "YEAR" ),
    QString( "EDITOR" ),
    QString( "BOOKTITLE" ),
    QString( "VOLUME" ),
    QString( "NUMBER" ),
    QString( "SERIES" ),
    QString( "CONF_LOCATION" ),
    QString( "CONF_DATE" ),
    QString( "ORGANISATION" ),
    QString( "PUBLISHER" ),
    QString( "ADDRESS" ),
    QString( "NOTE" ),
    QString( "URL" ),
    QString( "ABSTRACT" ),
    QString( "ANNOTE" ),
    QString( "-1" )};

const QString gProceedingsType[] = {
    QString( "EDITOR" ),
    QString( "TITLE" ),
    QString( "VOLUME" ),
    QString( "NUMBER" ),
    QString( "SERIES" ),
    QString( "MONTH" ),
    QString( "YEAR" ),
    QString( "CONF_LOCATION" ),
    QString( "CONF_DATE" ),
    QString( "ORGANISATION" ),
    QString( "PUBLISHER" ),
    QString( "ADDRESS" ),
    QString( "NOTE" ),
    QString( "URL" ),
    QString( "ANNOTE" ),
    QString( "-1" )};

const QString gInCollectionType[] = {
    QString( "AUTHOR" ),
    QString( "TITLE" ),
    QString( "CHAPTER" ),
    QString( "PAGES" ),
    QString( "MONTH" ),
    QString( "YEAR" ),
    QString( "EDITOR" ),
    QString( "BOOKTITLE" ),
    QString( "VOLUME" ),
    QString( "NUMBER" ),
    QString( "SERIES" ),
    QString( "PUBLISHER" ),
    QString( "ADDRESS" ),
    QString( "NOTE" ),
    QString( "URL" ),
    QString( "ABSTRACT" ),
    QString( "ANNOTE" ),
    QString( "-1" )};

const QString gCollectionType[] = {
    QString( "EDITOR" ),
    QString( "TITLE" ),
    QString( "MONTH" ),
    QString( "YEAR" ),
    QString( "VOLUME" ),
    QString( "NUMBER" ),
    QString( "SERIES" ),
    QString( "PUBLISHER" ),
    QString( "ADDRESS" ),
    QString( "NOTE" ),
    QString( "URL" ),
    QString( "ANNOTE" ),
    QString( "-1" )};

const QString gUnpublishedType[] = {
    QString( "AUTHOR" ),
    QString( "TITLE" ),
    QString( "MONTH" ),
    QString( "YEAR" ),
    QString( "NOTE" ),
    QString( "URL" ),
    QString( "ABSTRACT" ),
    QString( "ANNOTE" ),
    QString( "-1" )};

const QString gMiscType[] = {
    QString( "KEY" ),
    QString( "AUTHOR" ),
    QString( "TITLE" ),
    QString( "MONTH" ),
    QString( "YEAR" ),
    QString( "HOWPUBLISHED" ),
    QString( "NOTE" ),
    QString( "URL" ),
    QString( "ABSTRACT" ),
    QString( "ANNOTE" ),
    QString( "-1" )};




//============================================================
// completion lists

const QString gJournalCompletions[] = {
    QString( "Ann. Rev. Comp. Phys." ),
    QString( "Bull. Math. Biol." ),
    QString( "J. Chem. Phys." ),
    QString( "J. Math. Biol." ),
    QString( "J. Phys. A" ),
    QString( "J. Stat. Phys." ),
    QString( "J. theor. Biol." ),
    QString( "Nature" ),
    QString( "Phys. Rev. A" ),
    QString( "Phys. Rev. B" ),
    QString( "Phys. Rev. C" ),
    QString( "Phys. Rev. D" ),
    QString( "Phys. Rev. E" ),
    QString( "Phys. Rev. Lett." ),
    QString( "Physica A" ),
    QString( "Physica B" ),
    QString( "Physica C" ),
    QString( "Physica D" ),
    QString( "Physics Today" ),
    QString( "Proc. Natl. Acad. Sci. USA" ),
    QString( "Proc. R. Soc. London B" ),
    QString( "Science" ),
    QString( "-1" ) };

const QString gPublisherCompletions[] = {
    QString( "Chapman & Hall" ),
    QString( "Cambridge University Press" ),
    QString( "Harri Deutsch Verlag" ),
    QString( "Harvard University Press" ),
    QString( "IEEE Press" ),
    QString( "John Wiley & Sons, Inc." ),
    QString( "MIT Press" ),
    QString( "Oxford University Press" ),
    QString( "Princeton University Press" ),
    QString( "Springer Verlag" ),
    QString( "University of Chicago Press" ),
    QString( "-1" ) };

const QString gAddressCompletions[] = {
    QString( "Cambridge, MA" ),
    QString( "Cambridge, UK" ),
    QString( "Chicago" ),
    QString( "London" ),
    QString( "New York" ),
    QString( "Oxford, UK" ),
    QString( "Princeton, NJ" ),
    QString( "-1" ) };

const QString gMonthCompletions[] = {
    QString( "Jan." ),
    QString( "January" ),
    QString( "Feb." ),
    QString( "February" ),
    QString( "Mar." ),
    QString( "March" ),
    QString( "Apr." ),
    QString( "April" ),
    QString( "May" ),
    QString( "Jun." ),
    QString( "June" ),
    QString( "Jul." ),
    QString( "July" ),
    QString( "Oct." ),
    QString( "October" ),
    QString( "Nov." ),
    QString( "November" ),
    QString( "Dec." ),
    QString( "December" ),
    QString( "-1" ) };




#undef FIELDTYPE
#undef QSTRING
#undef AUTHORLIST
#undef STRING
#undef TEXT












