/***************************************************************************
                          startscreen.cpp  -  description
                             -------------------
    begin                : Tue Apr 4 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@kpage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          startscreen.cpp  -  description
                             -------------------
    begin                : Mon Apr 3 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@kpage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "startscreen.h"

#include "sprites/background/startscreen.xpm"

StartScreen::StartScreen(QWidget *parent, const char *name, WFlags f )
		   : QWidget(parent,name,f)
{
	QPixmap stPic;
	stPic = QPixmap ((const char **)startscreen_xpm);
	this->setBackgroundPixmap(stPic);

	QAccel *acc = new QAccel(this);
	acc->connectItem( acc->insertItem(Key_Return),this, SLOT(startGame()) );
	acc->connectItem( acc->insertItem(Key_Space),this, SLOT(startGame()) );

	soundBox = new QCheckBox(i18n("Play with Sound"), this);
	soundBox->setGeometry(20,280,160,20);
	soundBox->setBackgroundColor(white);
	soundBox->setChecked(true);

	startBut = new QPushButton(i18n("Start"), this);
	startBut->setGeometry(220,270,60,20);
	startBut->setBackgroundColor(white);
	connect(startBut, SIGNAL(clicked()), this, SLOT(startGame()));

	this->show();
}

StartScreen::~StartScreen()
{
	delete(soundBox);
	delete(startBut);
}

void StartScreen::startGame()
{
	kinsectizid = new KInsectizid();
	kinsectizid->setFixedSize(800,600);
	kinsectizid->sound=soundBox->isChecked();

	kinsectizid->show();
	kapp->setMainWidget(kinsectizid);

	this->hide();
	delete(this);
}