/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [te_widget.h]           Terminal Emulation Widget                          */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

#ifndef TE_WIDGET_H
#define TE_WIDGET_H

#include <qwidget.h>
#include <qlabel.h>
#include <qcolor.h>
#include <qkeycode.h>

#include "TECommon.h"

class TEWidget : public QWidget
// a widget representing attributed text
{ Q_OBJECT

public:

    TEWidget(QWidget *parent=0, const char *name=0);

public:
    void setDefaultForeColor(QColor);
    void setDefaultBackColor(QColor);
    QColor getDefaultForeColor();
    QColor getDefaultBackColor();

public:
    
    void setImage(const ca* const newimg, int lines, int columns);

    int  Lines()   { return lines;   }
    int  Columns() { return columns; }

public:

    void Bell();

signals:

    void keyPressedSignal(QKeyEvent *e);
    void mouseSignal(int cb, int cx, int cy);
    void changedImageSizeSignal(int lines, int columns);
    void configureRequest( TEWidget*, int x, int y );

protected:

    bool eventFilter( QObject *, QEvent * );

    void paintEvent( QPaintEvent * );
    void resizeEvent(QResizeEvent*);

    void mousePressEvent( QMouseEvent* );
    void mouseReleaseEvent( QMouseEvent* );

private:

    QFont f;
    int font_h; // height
    int font_w; // width
    int font_a; // ascend

    int lines;
    int columns;
    ca *image; // [lines][columns]

    QColor color_table[ALL_COLORS];

    BOOL resizing;

    void clearImage();
    void makeImage();

};

#endif // TE_WIDGET_H
