/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [kom.h]                       Main Widget                                */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

#ifndef KOM_H
#define KOM_H

#include <qwidget.h>
#include <qcolor.h>
#include <qpopmenu.h>
#include <qlabel.h>
#include <qtooltip.h>

// what on earth is this bull.... #define for?
#define STDC_HEADERS
#define HAVE_UNISTD_H
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <kfm.h>
#include <kapp.h>
#include <ktopwidget.h>

#include "status.h"
#include "ansiterm.h"
#include "zmodem.h"
#include "iemsi.h"
#include "iemsi_view.h"
#include "modem.h"

class Kom : public KTopLevelWidget // QWidget
{
    Q_OBJECT
public:
    Kom( QWidget *parent=0, const char *name=0 );
    ~Kom();

private:
    Modem*        mo;

    AnsiTerminal* at;

    IemsiClientInfo* ici;
    IemsiServerInfo* isi;
    IemsiView*    ie_v;    // FIXME: needed here?

signals:
    void stopProtocol();

private slots:
    void triggerProtocol(int);
    void doneProtocol();
    void rcv_isi(IemsiServerInfo* isi);

private slots:

    // MENU
    void open_new();
    void about();
    void help();
    void iemsi(); //FIXME: choose better name;
    void dial(); //FIXME: choose better name;
    void upload();
    void hangup();
    void stop();
    void chgConnect(bool);
    // INIT
    void init_1();
    void init_2();
    // DND
    void slotDropEvent( KDNDDropZone * _dropZone );

private:

    KMenuBar*   menubar;
    KToolBar*   toolbar;

	QPopupMenu* m_file;
    StatusLine* st;

    int         menuLastIemsi;
    int         menuStop;
    int         menuHangup;

    Kom::sendFiles(QStrList* lst);

    void Kom::createToolbar();
};

#endif // Kom_H
