//Auto-generated by kalyptus. DO NOT EDIT.
namespace KIO {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  The KIO.Scheduler manages io-slaves for the application.
    ///  It also queues jobs and assigns the job to a slave when one
    ///  becomes available.
    ///  There are 3 possible ways for a job to get a slave:
    ///  <h3>1. Direct</h3>
    ///  This is the default. When you create a job the
    ///  KIO.Scheduler will be notified and will find either an existing
    ///  slave that is idle or it will create a new slave for the job.
    ///  Example:
    ///  <pre>
    ///     TransferJob job = KIO.Get(KUrl("http://www.kde.org"));
    ///  </pre>
    ///  <h3>2. Scheduled</h3>
    ///  If you create a lot of jobs, you might want not want to have a
    ///  slave for each job. If you schedule a job, a maximum number
    ///  of slaves will be created. When more jobs arrive, they will be
    ///  queued. When a slave is finished with a job, it will be assigned
    ///  a job from the queue.
    ///  Example:
    ///  <pre>
    ///     TransferJob job = KIO.Get(KUrl("http://www.kde.org"));
    ///     KIO.Scheduler.ScheduleJob(job);
    ///  </pre>
    ///  <h3>3. Connection Oriented</h3>
    ///  For some operations it is important that multiple jobs use
    ///  the same connection. This can only be ensured if all these jobs
    ///  use the same slave.
    ///  You can ask the scheduler to open a slave for connection oriented
    ///  operations. You can then use the scheduler to assign jobs to this
    ///  slave. The jobs will be queued and the slave will handle these jobs
    ///  one after the other.
    ///  Example:
    ///  <pre>
    ///     Slave slave = KIO.Scheduler.GetConnectedSlave(
    ///             KUrl("pop3://bastian:password@mail.kde.org"));
    ///     TransferJob job1 = KIO.Get(
    ///             KUrl("pop3://bastian:password@mail.kde.org/msg1"));
    ///     KIO.Scheduler.AssignJobToSlave(slave, job1);
    ///     TransferJob job2 = KIO.Get(
    ///             KUrl("pop3://bastian:password@mail.kde.org/msg2"));
    ///     KIO.Scheduler.AssignJobToSlave(slave, job2);
    ///     TransferJob job3 = KIO.Get(
    ///             KUrl("pop3://bastian:password@mail.kde.org/msg3"));
    ///     KIO.Scheduler.AssignJobToSlave(slave, job3);
    ///     // ... Wait for jobs to finish...
    ///     KIO.Scheduler.DisconnectSlave(slave);
    ///  </pre>
    ///  Note that you need to explicitly disconnect the slave when the
    ///  connection goes down, so your error handler should contain:
    ///  <pre>
    ///     if (error == KIO.ERR_CONNECTION_BROKEN)
    ///         KIO.Scheduler.DisconnectSlave(slave);
    ///  </pre>
    /// </remarks>        <short>    The KIO.Scheduler manages io-slaves for the application.</short>
    ///         <see> Slave</see>
    ///         <see> Job</see>
    [SmokeClass("KIO::Scheduler")]
    public class Scheduler : QObject {
        protected Scheduler(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Scheduler), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static Scheduler() {
            staticInterceptor = new SmokeInvocation(typeof(Scheduler), null);
        }
        public bool Connect(QObject sender, string signal, string member) {
            return (bool) interceptor.Invoke("connect#$$", "connect(const QObject*, const char*, const char*)", typeof(bool), typeof(QObject), sender, typeof(string), signal, typeof(string), member);
        }
        /// <remarks>
        ///  Register <code>job</code> with the scheduler.
        ///  The default is to create a new slave for the job if no slave
        ///  is available. This can be changed by calling scheduleJob.
        /// <param> name="job" the job to register
        ///          </param></remarks>        <short>    Register <code>job</code> with the scheduler.</short>
        public static void DoJob(KIO.SimpleJob job) {
            staticInterceptor.Invoke("doJob#", "doJob(KIO::SimpleJob*)", typeof(void), typeof(KIO.SimpleJob), job);
        }
        /// <remarks>
        ///  Calling ths function makes that <code>job</code> gets scheduled for later
        ///  execution, if multiple jobs are registered it might wait for
        ///  other jobs to finish.
        /// <param> name="job" the job to schedule
        ///          </param></remarks>        <short>    Calling ths function makes that <code>job</code> gets scheduled for later  execution, if multiple jobs are registered it might wait for  other jobs to finish.</short>
        public static void ScheduleJob(KIO.SimpleJob job) {
            staticInterceptor.Invoke("scheduleJob#", "scheduleJob(KIO::SimpleJob*)", typeof(void), typeof(KIO.SimpleJob), job);
        }
        /// <remarks>
        ///  Stop the execution of a job.
        /// <param> name="job" the job to cancel
        ///          </param></remarks>        <short>    Stop the execution of a job.</short>
        public static void CancelJob(KIO.SimpleJob job) {
            staticInterceptor.Invoke("cancelJob#", "cancelJob(KIO::SimpleJob*)", typeof(void), typeof(KIO.SimpleJob), job);
        }
        /// <remarks>
        ///  Called when a job is done.
        /// <param> name="job" the finished job
        /// </param><param> name="slave" the slave that executed the <code>job</code>
        ///          </param></remarks>        <short>    Called when a job is done.</short>
        public static void JobFinished(KIO.SimpleJob job, KIO.Slave slave) {
            staticInterceptor.Invoke("jobFinished##", "jobFinished(KIO::SimpleJob*, KIO::Slave*)", typeof(void), typeof(KIO.SimpleJob), job, typeof(KIO.Slave), slave);
        }
        /// <remarks>
        ///  Puts a slave on notice. A next job may reuse this slave if it
        ///  requests the same URL.
        ///  A job can be put on hold after it has emit'ed its mimetype.
        ///  Based on the mimetype, the program can give control to another
        ///  component in the same process which can then resume the job
        ///  by simply asking for the same URL again.
        /// <param> name="job" the job that should be stopped
        /// </param><param> name="url" the URL that is handled by the <code>url</code>
        ///          </param></remarks>        <short>    Puts a slave on notice.</short>
        public static void PutSlaveOnHold(KIO.SimpleJob job, KUrl url) {
            staticInterceptor.Invoke("putSlaveOnHold##", "putSlaveOnHold(KIO::SimpleJob*, const KUrl&)", typeof(void), typeof(KIO.SimpleJob), job, typeof(KUrl), url);
        }
        /// <remarks>
        ///  Removes any slave that might have been put on hold. If a slave
        ///  was put on hold it will be killed.
        ///          </remarks>        <short>    Removes any slave that might have been put on hold.</short>
        public static void RemoveSlaveOnHold() {
            staticInterceptor.Invoke("removeSlaveOnHold", "removeSlaveOnHold()", typeof(void));
        }
        /// <remarks>
        ///  Send the slave that was put on hold back to KLauncher. This
        ///  allows another process to take over the slave and resume the job
        ///  that was started.
        ///          </remarks>        <short>    Send the slave that was put on hold back to KLauncher.</short>
        public static void PublishSlaveOnHold() {
            staticInterceptor.Invoke("publishSlaveOnHold", "publishSlaveOnHold()", typeof(void));
        }
        /// <remarks>
        ///  Requests a slave for use in connection-oriented mode.
        /// <param> name="url" This defines the username,password,host & port to
        ///             connect with.
        /// </param><param> name="config" Configuration data for the slave.
        /// </param></remarks>        <return> A pointer to a connected slave or 0 if an error occurred.
        /// </return>
        ///         <short>    Requests a slave for use in connection-oriented mode.</short>
        ///         <see> assignJobToSlave</see>
        ///         <see> disconnectSlave</see>
        public static KIO.Slave GetConnectedSlave(KUrl url, KIO.MetaData config) {
            return (KIO.Slave) staticInterceptor.Invoke("getConnectedSlave##", "getConnectedSlave(const KUrl&, const KIO::MetaData&)", typeof(KIO.Slave), typeof(KUrl), url, typeof(KIO.MetaData), config);
        }
        public static KIO.Slave GetConnectedSlave(KUrl url) {
            return (KIO.Slave) staticInterceptor.Invoke("getConnectedSlave#", "getConnectedSlave(const KUrl&)", typeof(KIO.Slave), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Uses <code>slave</code> to do <code>job.</code>
        ///  This function should be called immediately after creating a Job.
        /// <param> name="slave" The slave to use. The slave must have been obtained
        ///               with a call to getConnectedSlave and must not
        ///               be currently assigned to any other job.
        /// </param><param> name="job" The job to do.
        /// </param></remarks>        <return> true is successful, false otherwise.
        /// </return>
        ///         <short>    Uses <code>slave</code> to do <code>job.</code></short>
        ///         <see> getConnectedSlave</see>
        ///         <see> disconnectSlave</see>
        ///         <see> slaveConnected</see>
        ///         <see> slaveError</see>
        public static bool AssignJobToSlave(KIO.Slave slave, KIO.SimpleJob job) {
            return (bool) staticInterceptor.Invoke("assignJobToSlave##", "assignJobToSlave(KIO::Slave*, KIO::SimpleJob*)", typeof(bool), typeof(KIO.Slave), slave, typeof(KIO.SimpleJob), job);
        }
        /// <remarks>
        ///  Disconnects <code>slave.</code>
        /// <param> name="slave" The slave to disconnect. The slave must have been
        ///               obtained with a call to getConnectedSlave
        ///               and must not be assigned to any job.
        /// </param></remarks>        <return> true is successful, false otherwise.
        /// </return>
        ///         <short>    Disconnects <code>slave.</code></short>
        ///         <see> getConnectedSlave</see>
        ///         <see> assignJobToSlave</see>
        public static bool DisconnectSlave(KIO.Slave slave) {
            return (bool) staticInterceptor.Invoke("disconnectSlave#", "disconnectSlave(KIO::Slave*)", typeof(bool), typeof(KIO.Slave), slave);
        }
        /// <remarks>
        ///  Register the mainwindow <code>wid</code> with the KIO subsystem
        ///  Do not call this, it is called automatically from
        ///  void KIO.Job.SetWindow(QWidget).
        /// <param> name="wid" the window to register
        ///          </param></remarks>        <short>    Register the mainwindow <code>wid</code> with the KIO subsystem  Do not call this, it is called automatically from  void KIO.Job.SetWindow(QWidget ).</short>
        public static void RegisterWindow(QWidget wid) {
            staticInterceptor.Invoke("registerWindow#", "registerWindow(QWidget*)", typeof(void), typeof(QWidget), wid);
        }
        /// <remarks>
        ///  Unregisters the window registered by registerWindow().
        ///          </remarks>        <short>   </short>
        public static void UnregisterWindow(QObject wid) {
            staticInterceptor.Invoke("unregisterWindow#", "unregisterWindow(QObject*)", typeof(void), typeof(QObject), wid);
        }
        /// <remarks>
        ///  Function to connect signals emitted by the scheduler.
        /// </remarks>        <short>    Function to connect signals emitted by the scheduler.</short>
        ///         <see> slaveConnected</see>
        ///         <see> slaveError</see>
        public static bool Connect(string signal, QObject receiver, string member) {
            return (bool) staticInterceptor.Invoke("connect$#$", "connect(const char*, const QObject*, const char*)", typeof(bool), typeof(string), signal, typeof(QObject), receiver, typeof(string), member);
        }
        public static new bool Connect(QObject sender, string signal, QObject receiver, string member) {
            return (bool) staticInterceptor.Invoke("connect#$#$", "connect(const QObject*, const char*, const QObject*, const char*)", typeof(bool), typeof(QObject), sender, typeof(string), signal, typeof(QObject), receiver, typeof(string), member);
        }
        public static new bool Disconnect(QObject sender, string signal, QObject receiver, string member) {
            return (bool) staticInterceptor.Invoke("disconnect#$#$", "disconnect(const QObject*, const char*, const QObject*, const char*)", typeof(bool), typeof(QObject), sender, typeof(string), signal, typeof(QObject), receiver, typeof(string), member);
        }
        /// <remarks>
        ///  When true, the next job will check whether KLauncher has a slave
        ///  on hold that is suitable for the job.
        /// <param> name="b" true when KLauncher has a job on hold
        ///          </param></remarks>        <short>    When true, the next job will check whether KLauncher has a slave  on hold that is suitable for the job.</short>
        public static void CheckSlaveOnHold(bool b) {
            staticInterceptor.Invoke("checkSlaveOnHold$", "checkSlaveOnHold(bool)", typeof(void), typeof(bool), b);
        }
        public static void EmitReparseSlaveConfiguration() {
            staticInterceptor.Invoke("emitReparseSlaveConfiguration", "emitReparseSlaveConfiguration()", typeof(void));
        }
        protected new ISchedulerSignals Emit {
            get { return (ISchedulerSignals) Q_EMIT; }
        }
    }

    public interface ISchedulerSignals : IQObjectSignals {
    }
}
