
/**
 *
 *  This file is part of the kdewebdev package
 *  Copyright (c) 2002 Keith Isdale <keith@kdewebdev.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef KXSLDBG_PART_H
#define KXSLDBG_PART_H

#include <kparts/part.h>
#include <QVariant>
#include <QMainWindow>
#include <QActionGroup>
#include <QHash>
#include <QMenu>
#include "xsldbgdebugger.h"
#include "xsldbginspector.h"
#include <ktexteditor/document.h> 
#include <ktexteditor/view.h> 
#include <QDBusConnection>
class KxsldbgAdaptor;

class QGridLayout;
class QAction;
class QLineEdit;
class QDockWindow;
class QStackedWidget;

class XsldbgBrkStatusView;
class QXsldbgDoc;
class XsldbgOutputView;
class XsldbgConfigImpl;
class ConfigDialogPrivate;

class QWidget;
class QPainter;
class KUrl;
class KAboutData;

typedef QHash<QString, QXsldbgDoc*> XsldbgDocDict;

/**
 * This is a "Part".  It that does all the real work in a KPart
 * application.
 *
 * @short Main Part
 * @author Keith Isdale <keith@kdewebdev.org>
 * @version 0.1
 */
class KXsldbgPart : public KParts::ReadOnlyPart
{
  friend class KxsldbgAdaptor;

    Q_OBJECT

public:
    /**
     * Default constructor
     */
    KXsldbgPart(QWidget *parentWidget,
                    QObject *parent,const QStringList &args);

    /**
     * Destructor
     */
    virtual ~KXsldbgPart();

    static KAboutData *createAboutData();


   /** Checks the debugger, if it is not ready then
     *      display a error in a message box
     *
     * @returns TRUE if debugger is ready, otherwise FALSE
     */
    bool checkDebugger();
    void lookupSystemID(QString systemID);
    void lookupPublicID(QString publicID);
    void createInspector();

Q_SIGNALS:
    Q_SCRIPTABLE void newCursorPosition(const QString &file, int lineNumber, int columnNumber);
    Q_SCRIPTABLE void newDebuggerPosition(const QString &file, int lineNumber);

public slots:
    virtual bool openUrl(const KUrl &url);
    virtual bool closeUrl();
    void quit();
    void emitOpenFile(QString file, int line, int row);
    void slotLookupSystemID();
    void slotLookupPublicID();
    void walkCmd_activated();
    void walkStopCmd_activated();
    void traceCmd_activated();
    void traceStopCmd_activated();
    void configureEditorCmd_activated(); 

  //Tool bar commands
    void configureCmd_activated();
    void inspectorCmd_activated();
    void runCmd_activated();
    void stepCmd_activated();
    void nextCmd_activated();
    void continueCmd_activated();
    void stepupCmd_activated();
    void stepdownCmd_activated();
    void sourceCmd_activated();
    void dataCmd_activated();
    void outputCmd_activated();
    void refreshCmd_activated();
    void enableCmd_activated();
    void breakCmd_activated();
    void deleteCmd_activated();

    /** Evaluate expression entered */	
    void evaluateCmd_activated();

    /** Goto/display file XPath entered */
    void gotoXPathCmd_activated();

    virtual void lineNoChanged( QString fileName, int lineNumber,
				bool breakpoint );

    void addBreakPoint(int lineNumber);
    void enableBreakPoint(int lineNumber);
    void deleteBreakPoint(int lineNumber);

    /** Evaluate expression entered in expressionEdit */
    void slotEvaluate();

    /** Goto/display file that matches XPath specified in xPathEdit */
    void slotGotoXPath();

     /** Run search on data base , see search.dtd for DTD of search database */
    void slotSearch();

    /* Process the URI for SystemID or PublicID requested */
    void slotProcResolveItem(QString URI);

    /* used to get breakpoint list notfication */
    void breakpointItem(QString fileName, int  lineNumber ,
			QString /*templateName*/, QString /* modeName */,
			bool  enabled , int /* id */);

    void cursorPositionChanged();
    void docChanged();
    
    void debuggerStarted();
    void debuggerStopped();

protected:
    /**
     * This must be implemented by each part
     */
    virtual bool openFile();
    bool fetchURL(const KUrl &url);

protected slots:
    void fileOpen();

private:
    QXsldbgDoc *currentDoc;
    QStackedWidget *mainView;
    QDBusInterface *dbusIface;

    QPushButton *xPathBtn, *searchBtn, *evaluateBtn;
    QLineEdit *newXPath, *newSearch, *newEvaluate;
    QGridLayout* qxsldbgLayout;

    uint currentLineNo, currentColumnNo;
    XsldbgDocDict docDictionary;
    XsldbgInspector *inspector;
    XsldbgDebugger *debugger;
    XsldbgConfigImpl *configWidget;
    QString currentFileName;

    XsldbgOutputView *outputview;
    ConfigDialogPrivate *dlg;// wrapper for the config dialog
};
#endif // KXSLDBG_PART_H
